#include "kernelmessageswindow.h"
#include "ui_kernelmessageswindow.h"

KernelMessagesWindow::KernelMessagesWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::KernelMessagesWindow)
{
    ui->setupUi(this);
    connect(ui->actionExport, SIGNAL(triggered()), this, SLOT(exportlogs()));
    setAttribute(Qt::WA_DeleteOnClose);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    process = new QProcess(this);
    process->start("dmesg");
    process->waitForFinished();
    QString dmesg = process->readAllStandardOutput();
    QStringList dmesgList = dmesg.split("\n");
    dmesgList = dmesgList.filter("PSFreedom");
    ui->textBrowser->setText(dmesgList.join("\n"));
    QMainWindow::setCentralWidget(ui->verticalLayoutWidget);
}

KernelMessagesWindow::~KernelMessagesWindow()
{
    process->kill();
    delete ui;
}

void KernelMessagesWindow::exportlogs()
{
    //system("dmesg | grep PSFreedom* > /home/user/MyDocs/PSFreedom.txt && chown user:users /home/user/MyDocs/PSFreedom.txt");
    process->start("dmesg");
    process->waitForFinished();
    QString dmesg = process->readAllStandardOutput();
    QStringList dmesgList = dmesg.split("\n");
    dmesgList = dmesgList.filter("PSFreedom");
    QString logs = dmesgList.join("\n").append("\n");
    QFile exportedLogs("/home/user/MyDocs/PSFreedom.txt");
    exportedLogs.open(QIODevice::WriteOnly);
    exportedLogs.write(logs.toAscii());
    exportedLogs.close();
    exportedLogs.setPermissions(QFile::WriteOther);
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information(0, tr("Saved to /home/user/MyDocs/PSFreedom.txt"));
#endif
}
