#include "helpwindow.h"
#include "ui_helpwindow.h"

#ifdef Q_WS_MAEMO_5
#include <QtGui/QX11Info>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#endif

HelpWindow::HelpWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::HelpWindow)
{
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
#endif
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);
    qDebug() << "HelpWindow: UI ready.";
#ifdef Q_WS_MAEMO_5
    //HelpWindow::setAttribute(Qt::WA_Maemo5AutoOrientation, false);
    //HelpWindow::setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
    //http://www.gossamer-threads.com/lists/maemo/developers/54239
    quint32 disable = {0};
    Atom winPortraitModeSupportAtom = XInternAtom(QX11Info::display(), "_HILDON_PORTRAIT_MODE_SUPPORT", false);
    XChangeProperty(QX11Info::display(), winId(), winPortraitModeSupportAtom, XA_CARDINAL, 32, PropModeReplace, (uchar*) &disable, 1);
#endif
//    ui->kernelMessagesButton->hide();
    ui->imageLabel->setPixmap(QPixmap(":/images/version.png"));
    //ui->imageLabel->paintEngine();
    connect(ui->phatButton, SIGNAL(clicked()), this, SLOT(showhelpPhat()));
    connect(ui->slimButton, SIGNAL(clicked()), this, SLOT(showhelpSlim()));
}

HelpWindow::~HelpWindow()
{
    qDebug() << "HelpWindow: deleting UI...";
    delete ui;
}

void HelpWindow::showhelpPhat()
{
    qDebug() << "HelpWindow: showing Phat help widgets.";
    ui->phatButton->hide();
    ui->slimButton->hide();
    ui->imageLabel->hide();
    HDraggableViewArea *views = new HDraggableViewArea(ui->widget);
    views->addWidget(new DisplayPage(":/images/phat1.png", ui->widget));
    views->addWidget(new DisplayPage(":/images/phat2.png", ui->widget));
    views->addWidget(new DisplayPage(":/images/phat3.png", ui->widget));
    views->addWidget(new DisplayPage(":/images/phat4.png", ui->widget));
    views->addWidget(new DisplayPage(":/images/page5.png", ui->widget));
    this->setCentralWidget(views);
    views->show();
#ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(this, tr("<--- Swipe left and right to move between images --->"));
#endif
}

void HelpWindow::showhelpSlim()
{
    qDebug() << "HelpWindow: showing Slim help widgets.";
    ui->phatButton->hide();
    ui->slimButton->hide();
    ui->imageLabel->hide();
    HDraggableViewArea *views = new HDraggableViewArea(ui->widget);
    views->addWidget(new DisplayPage(":/images/slim1.png", ui->widget));
    views->addWidget(new DisplayPage(":/images/slim2.png", ui->widget));
    views->addWidget(new DisplayPage(":/images/slim3.png", ui->widget));
    views->addWidget(new DisplayPage(":/images/slim4.png", ui->widget));
    views->addWidget(new DisplayPage(":/images/page5.png", ui->widget));
    this->setCentralWidget(views);
    views->show();
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information(this, tr("<--- Swipe left and right to move between images --->"));
#endif
}
