#include "aboutwindow.h"
#include "ui_aboutwindow.h"
#include "qwebviewselectionsuppressor.h"
#ifdef Q_WS_MAEMO_5
    #include <QtGui/qabstractkineticscroller.h>
#endif

AboutWindow::AboutWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::AboutWindow)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_DeleteOnClose);
    qDebug() << "AboutWindow: UI ready.";
    QMainWindow::setCentralWidget(ui->webView);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
    suppressor = new QWebViewSelectionSuppressor(ui->webView);
    suppressor->enable();
    ui->webView->property("kineticScroller").value<QAbstractKineticScroller *>()->setEnabled(true);
    qDebug() << "AboutWindow: On Maemo 5, kinetic scrolling enabled.";
    connect(ui->webView, SIGNAL(loadStarted()), this, SLOT(setProgressIndicatorOn()));
    connect(ui->webView, SIGNAL(loadFinished(bool)), this, SLOT(setProgressIndicatorOff()));
#endif
    if(QFile::exists("/opt/psfreedom/resources/aboutpsfreedom.html")) {
        qDebug() << "AboutWindow: Opening file:///opt/psfreedom/resources/aboutpsfreedom.html";
        ui->webView->setUrl(QUrl("file:///opt/psfreedom/resources/aboutpsfreedom.html"));
    } else {
        qDebug() << "AboutWindow: Uh-oh! About file missing, oh well, we have backup!";
        qDebug() << "AboutWindow: Opening http://bashdesigns.co.uk/psf/aboutpsfreedom.html";
        ui->webView->setUrl(QUrl("http://bashdesigns.co.uk/psf/aboutpsfreedom.html"));
    }
}

AboutWindow::~AboutWindow()
{
    delete ui;
}

void AboutWindow::setProgressIndicatorOn()
{
#ifdef Q_WS_MAEMO_5
    this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
}

void AboutWindow::setProgressIndicatorOff()
{
#ifdef Q_WS_MAEMO_5
    this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}
