#include "compatibilitywindow.h"
#include "ui_compatibilitywindow.h"


CompatibilityWindow::CompatibilityWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::CompatibilityWindow)
{
    ui->setupUi(this);
    qDebug() << "CompatibilityWindow: UI ready.";
    QMainWindow::setCentralWidget(ui->verticalLayoutWidget);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
    suppressor = new QWebViewSelectionSuppressor(ui->webView);
    suppressor->enable();
    ui->webView->property("kineticScroller").value<QAbstractKineticScroller *>()->setEnabled(true);
    qDebug() << "CompatibilityWindow: On Maemo 5, kinetic scrolling enabled.";
#endif
    qDebug() << "CompatibilityWindow: Opening http://psjcl.com";
    ui->webView->setUrl(QUrl("http://psjcl.com"));
    qDebug() << "CompatibilityWindow: Setting zoom level to 1.2";
    ui->webView->setZoomFactor(1.2);
}

CompatibilityWindow::~CompatibilityWindow()
{
    qDebug() << "CompatibilityWindow: deleting UI...";
    delete ui;
}
