#!/bin/sh

SYMLINK=/opt/psfreedom/modules/psfreedom.ko
STOCKVERSION=2.6.28-omap1
POWERVERSION=2.6.28.10power40
NEOPWNVERSION=2.6.28.10power40-wl1

become_root ()
{
	if [ `id -u` != 0 ] ; then
		#if not already root, call itself as root - thanks, fanoush
		echo "Not root. Calling sudo..."
		echo
		exec sudo $0 $*
		exit $?
	fi
}

link()
{
become_root $*
if [ "`uname -r`" = "$STOCKVERSION" ];
	then
	if [ -f $SYMLINK ];
		then rm $SYMLINK
	fi
	ln -s $MODDIR/omap1/psfreedom.ko $SYMLINK
fi

if [ "`uname -r`" = "$POWERVERSION" ] || [ "`uname -r`" = "$NEOPWNVERSION" ];
	then
	if [ -f $SYMLINK ];
		then rm $SYMLINK
	fi
	ln -s $MODDIR/power40/psfreedom.ko $SYMLINK
fi
}

argv0=$1 #Fucking BusyBox
case "$argv0" in
	--pl3)
		rm -f $SYMLINK
		MODDIR=/opt/psfreedom/modules/pl3 link
		;;

	--hermes)
		rm -f $SYMLINK
		MODDIR=/opt/psfreedom/modules/hermes link
		;;

	*)
		echo "Module selection and detection script, use --pl3 for the PL3 payloads, --hermes for Hermes payloads"
		echo "No module type selected, creating PL3 module symlinks."
		MODDIR=/opt/psfreedom/modules/pl3 link
		;;
esac


exit

