#!/bin/sh

# Status file
STATUS=/proc/psfreedom/status

if [ ! -f $STATUS ];
	then
		echo "Status file does not exist, module not loaded?" && exit 1
fi

if [ -f /proc/psfreedom/payload ]; then
	PAYLOAD=`cat /proc/psfreedom/payload | grep dev`
fi

# From FMTX-faker, thanks qwerty12
become_root ()
{
	if [ `id -u` != 0 ] ; then
		#if not already root, call itself as root - thanks, fanoush
		echo "Not root. Calling sudo..."
		echo
		exec sudo $0 $*
		exit $?
	fi
}


#	become_root $*

enablebdemu()
{
	become_root $*

	cat /lib/firmware/payload_bdemu.bin > /proc/psfreedom/payload
}

disablebdemu()
{
	become_root $*

	cat /lib/firmware/payload_no_bdemu.bin > /proc/psfreedom/payload
}

status()
{
	if [ -f $STATUS ];
		then
			echo "Status file does not exist, module not loaded?" && exit 1
		else
			if [ "$PAYLOAD" = "/dev_xxxx" ];
				then
					echo "BD Emulation disabled, backups will not start."
			fi
			
			if [ "$PAYLOAD" = "/dev_bdvd" ];
				then
					echo "BD Emulation enabled, use Backup Manager to load backups."
			fi
	fi
}

help ()
{
	echo "PSFreedom helper script, use to change payload"
	echo 	
	echo "Usage: --enaablebdemu | --disablebdemu | --status | --help"

	exit 1
}


argv0=$1
case "$argv0" in
	-e|--enablebdemu|enablebdemu)
		enablebdemu $*
		;;

	-d|--disablebedmu|disablebdemu)
		disablebdemu $*
		;;

	-s|--status|status)
		status $*
		;;

	*)
		help $0
		;;
esac


