#include <QApplication>
#include <QtDBus/QtDBus>
#include <QtDBus/QDBusConnection>
#include <QProcess>
#include <QFile>
#include <QObject>
#include <mce/dbus-names.h> 

#define PROXIMITY_STATE "/sys/devices/platform/gpio-switch/proximity/state" 


class checker : public QObject
{
  Q_OBJECT
public:
  checker(QObject * o = 0) : QObject(o) {}

public slots:
  void CheckProximity()
  {

	/* cat /sys/devices/platform/gpio-switch/proximity/state */
	QFile file(PROXIMITY_STATE);
	if ( file.open(QIODevice::ReadOnly) ) {       
	// file opened successfully
		QTextStream t( &file );        // use a text stream

                if ( t.readLine().compare("closed", Qt::CaseSensitive) == 0 ) {
                    //start the GUI
                    QProcess ps;
                    ps.start("/usr/bin/proximityclock-clock");
                    QDBusMessage m = QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF, MCE_TKLOCK_MODE_CHANGE_REQ);

                    m << "unlocked";
                    QDBusConnection::systemBus().send(m);
                    sleep(60);
                    ps.kill();
                }

	}
	
        file.close();
    }
};

int main ( int argc, char *argv[] )
{
	QCoreApplication app(argc,argv);
	
        QTimer *timer = new QTimer();
        QObject::connect(timer, SIGNAL(timeout()), new checker(timer), SLOT(CheckProximity()));
	timer->start(100);
	
	return app.exec();

	
}

#include "proximityclock-daemon.moc"
