#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QDialog>
#include <QSettings>
#include <QPushButton>
#include <QDBusInterface>

#define PCW_SETTING_HEIGHT "profilechangerwidget/height"
#define PCW_SETTING_WIDTH "profilechangerwidget/width"
#define PCW_SETTING_OPACITY "profilechangerwidget/opacity"
#define PCW_SETTING_SHOWNEXTPROFILE "profilechangerwidget/showNextProfile"

namespace Ui {
    class SettingsDialog;
}

class SettingsDialog : public QDialog
{
    Q_OBJECT

signals:
    void settingsChanged();

public:
    explicit SettingsDialog(QWidget *parent = 0);
    ~SettingsDialog();

private:
    Ui::SettingsDialog *ui;
    void openBrowser(QString url);
    void showInformation(QString info);

private slots:
    void accept();
    void showAbout();
    void on_buttonAbout_clicked();
    void on_buttonQa_clicked();
    void on_buttonDonate_clicked();
    void on_buttonBox_accepted();
    void on_buttonBox_rejected();
};

#endif // SETTINGSDIALOG_H
