#include <QtGui/QApplication>
#include "profilechangerwidget.h"

int main(int argc, char *argv[])
{
    QApplication::setOrganizationName("hschmitt");
    QApplication::setApplicationName("profile-changer-widget");
    QApplication::setApplicationVersion("0.4-5");
    openlog("pcw",LOG_PID,LOG_USER);
    syslog(LOG_WARNING, "Starting profile-changer-widget");
    // enforce native graphics system for now due to a bug in transparency handling
    // you can remove this line if you only target PR 1.2
    if (qstrcmp(qVersion(), "4.7.2") == 0) {
        QApplication::setGraphicsSystem("native");
        syslog(LOG_DEBUG, "profile-changer-widget Using native graphicssystem");
    }

    QApplication app(argc, argv);
    syslog(LOG_WARNING, "profile-changer-widget adaptor");
    ProfileChangerWidget w;

    QMaemo5HomescreenAdaptor *adaptor = new QMaemo5HomescreenAdaptor(&w);
    syslog(LOG_WARNING, "profile-changer-widget settings");
//    adaptor->setSettingsAvailable(false);
    syslog(LOG_WARNING, "profile-changer-widget settings connect");
//    QObject::connect(adaptor, SIGNAL(settingsRequested()), &w, SLOT(onShowSettingsDialog()));
    syslog(LOG_WARNING, "profile-changer-widget show");
    w.show();
    syslog(LOG_WARNING, "profile-changer-widget app.exec");
    app.exec();
    closelog();
}

