#include "profilechangerwidget.h"
#include "ui_profilechangerwidget.h"

const QString iconSilent = "/usr/share/icons/hicolor/48x48/hildon/statusarea_silent.png";
const QString iconGeneral = "/usr/share/icons/hicolor/48x48/hildon/statusarea_volumelevel4.png";

ProfileChangerWidget::ProfileChangerWidget (QWidget *parent) :
QMainWindow(parent),
    ui(new Ui::ProfileChangerWidget)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_TranslucentBackground);
    if (!QSettings().contains("profilechangerwidget/width"))
        QSettings().setValue("profilechangerwidget/width", 48);
    if (!QSettings().contains("profilechangerwidget/height"))
        QSettings().setValue("profilechangerwidget/height", 48);

    connect(ui->switchButton, SIGNAL(clicked()), this, SLOT(onChangeProfileClicked()));
    this->reloadSettings();
}

ProfileChangerWidget::~ProfileChangerWidget()
{
    delete ui;
}

QString ProfileChangerWidget::getProfileName() {
    QString profileName = "";
    QDBusMessage msg = QDBusMessage::createMethodCall(
        "com.nokia.profiled", // --dest
        "/com/nokia/profiled", // destination object path
        "com.nokia.profiled", // message name (w/o method)
        "get_profile" // method
    );
    msg = QDBusConnection::systemBus().call(msg);

    if (msg.type() == QDBusMessage::ErrorMessage) {
        QErrorMessage* err = new QErrorMessage();
        err->showMessage(msg.errorMessage());
    } else if(msg.type() == QDBusMessage::ReplyMessage) {
        profileName = msg.arguments().at(0).toString();
    }
    return profileName;
}

void ProfileChangerWidget::setProfile(QString profileName) {
    QDBusMessage msg = QDBusMessage::createMethodCall(
        "com.nokia.profiled", // --dest
        "/com/nokia/profiled", // destination object path
        "com.nokia.profiled", // message name (w/o method)
        "set_profile" // method
    );
    msg << profileName;
    msg = QDBusConnection::systemBus().call(msg);
}
void ProfileChangerWidget::refreshIcon() {
    QString profileName = this->getProfileName();

    if ( profileName == "silent" ) {
        showIconSilent(); 
    }
    else {
        showIconGeneral();
    }
}
    

void ProfileChangerWidget::showIconSilent() {
    ui->switchButton->setIcon(QIcon(iconSilent));    
}

void ProfileChangerWidget::showIconGeneral() {
    ui->switchButton->setIcon(QIcon(iconGeneral));    
}

void ProfileChangerWidget::switchProfile() {
    QString profileName = this->getProfileName();
    if ( profileName == "silent" ) {
        this->setProfile("general");
    }
    else {
        this->setProfile("silent");
    }
}  

void ProfileChangerWidget::onChangeProfileClicked() {
    switchProfile();
    refreshIcon();
}

void ProfileChangerWidget::onShowSettingsDialog()
{
    SettingsDialog *dialog = new SettingsDialog(0);
    connect(dialog, SIGNAL(settingsChanged()), this, SLOT(reloadSettings()));
    dialog->show();
}

void ProfileChangerWidget::reloadSettings()
{
    this->setGeometry(this->x(), this->y(),
                      QSettings().value("profilechangerwidget/width").toInt(),
                      QSettings().value("profilechangerwidget/height").toInt());
    this->refreshIcon();
}

