'''
Created on Mar 20, 2010

@author: maemo
'''
import location
import gobject
class GPSPrayerLocator(object):
    
    def on_error(self,control, error, data):
        print "location error: %d... quitting" % error
        data.quit()
    
    def on_changed(self,device, data):
        if not device:
            return
        if device.fix:
            if device.fix[1] & location.GPS_DEVICE_LATLONG_SET:
                print "lat = %f, long = %f" % device.fix[4:6]
                self.prayerTime.calculatePrayerTimes(self.prayerTime.date,0,self.prayerTime.tz,device.fix[4],device.fix[5])
                data.stop()
    
    def on_stop(self,control, data):
        print "quitting"
        data.quit()
    
    def start_location(self,data):
        data.start()
        return False
    
    def useGPS(self,prayerTime):
        self.prayerTime = prayerTime
        loop = gobject.MainLoop()
        control = location.GPSDControl.get_default()
        device = location.GPSDevice()
        control.set_properties(preferred_method=location.METHOD_USER_SELECTED,
                               preferred_interval=location.INTERVAL_DEFAULT)
        
        control.connect("error-verbose", self.on_error, loop)
        device.connect("changed", self.on_changed, control)
        control.connect("gpsd-stopped", self.on_stop, loop)
        
        gobject.idle_add(self.start_location, control)
        
        loop.run()
