'''
Created on Mar 16, 2010

@author: maemo
'''
import math

class SunUtil(object):
    '''
    classdocs
    '''

    def abc(self,r):
        return (r * 180.0) / math.pi
    
    def sunPosition(self,jd):
        D = jd - 2451545.0;
        g = self.fixangle(357.529 + 0.98560028* D);
        q = self.fixangle(280.459 + 0.98564736* D);
        L = self.fixangle(q + 1.915* self.dsin(g) + 0.020* self.dsin(2*g));
        
        R = 1.00014 - 0.01671* self.dcos(g) - 0.00014* self.dcos(2*g);
        e = 23.439 - 0.00000036* D;
        
        d = self.darcsin(self.dsin(e)* self.dsin(L));
        RA = self.darctan2(self.dcos(e)* self.dsin(L), self.dcos(L))/ 15;
        RA = self.fixhour(RA);
        EqT = q/15 - RA;
        return (d,EqT)

  
    def timeDiff(self,a,lat,jd):
        const = 1.0/15.0
        rediusLat = self.dtr(lat)
        radiusA =self.dtr(a)
        D = self.eqOfTime(jd)[0]
        nom = -1*math.sin(radiusA) - (math.sin(rediusLat)*math.sin(self.dtr(D)));
        dom = math.cos(rediusLat)* math.cos(self.dtr(D))
        return const * self.abc(math.acos(nom/dom))

    def sunDeclination(self,jd):
        return self.sunPosition(jd)[0];
    
    def computeMidDay(self,t):
        T = self.equationOfTime(self.JDate+ t)
        Z = self.fixhour(12- T)
        return Z;
    
    def equationOfTime(self,jd):
        return self.sunPosition(jd)[1];
    
    def computeTime(self,G, t):
        D = self.sunDeclination(self.JDate+ t);
        Z = self.computeMidDay(t);
        V = 1.0/15.0* self.darccos((-self.dsin(G)- self.dsin(D)* self.dsin(self.lat)) /(self.dcos(D)* self.dcos(self.lat)));
        if(G > 90):
            return Z-V
        else:
            return Z + V

    def initZone(self,year, month, day, latitude, longitude, timeZone):
        self.lat = latitude
        self.lng = longitude
        #self.timeZone = self.effectiveTimeZone(year, month, day, timeZone); 
        self.JDate = self.juldate(year, month, day)- longitude/ (15* 24)
  
    def fixhour(self,a):
        a = a - 24.0 * (math.floor(a / 24.0))
        if(a < 0):
            return a+24
        else:
            return a

    def dtr(self,d) :
        return (d * math.pi) / 180.0
    
    

    def fixangle(self,a):
        a = a - 360.0 * (math.floor(a / 360.0))
	if (a < 0) :
          return (a + 360.0)
        else:
          return a
          
    def juldate(self,year,month,day):
        if (month <= 2) :
            year -= 1;
            month += 12;
        A = math.floor(year/ 100);
        B = 2- A+ math.floor(A/ 4);
        JD = math.floor(365.25* (year+ 4716))+ math.floor(30.6001* (month+ 1))+ day+ B- 1524.5;
        return JD;
          
    
    def dsin(self,d):
        return math.sin(self.dtr(d))
    def dcos(self,d):
        return math.cos(self.dtr(d));

    def dtan(self,d):
        return math.tan(self.dtr(d));

    def darcsin(self,x):
        return self.abc(math.asin(x));
    
    def darccos(self,x):
        return self.abc(math.acos(x));

    def darctan(self,x):
        return self.abc(math.atan(x))
    
    def darctan2(self,y, x):
        return self.abc(math.atan2(y, x))
    
    def darccot(self,x):
        return self.abc(math.atan(1/x))

    
    def __init__(self):
        '''
        Constructor
        '''
        