#    PPPoE Dialer Applet
#    Copyright (C) 2010  George James <itcl.george@@gmail.com>
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys
sys.path.append('../../../opt/pppoe-dialer/')

from subprocess import Popen, PIPE, call
import gtk
from hildondesktop import StatusMenuItem
import hildon
from gobject import timeout_add
import os
import subprocess
import conic
import time
import dbus
import gconf
#import pyinotify

from pppoemgrui import DialDialog
from pppoemgrui import DialAccountDialog
from pppoemgrui import pppoeui

import gobject
gobject.threads_init()

from dbus.mainloop.glib import DBusGMainLoop
dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)
dbus.mainloop.glib.threads_init()

enable_logging=False
fd=None
if enable_logging == True:
	fd = open('/tmp/pppoe-dialer-applet.log', 'w+')

#log function taken from openvpn-applet
def log(*input):
	if enable_logging:
		print input
		print >>fd,input
		fd.flush()

class pppoe_dialer_applet(StatusMenuItem):
    def __init__(self):
        StatusMenuItem.__init__(self)
	
	self.bus1 = None
	self.object = None
	self.interface = None
	try:
		self.bus1 = dbus.bus.BusConnection('unix:path=/var/run/dbus/system_bus_socket')
		self.object = self.bus1.get_object('org.freedesktop.Notifications', '/org/freedesktop/Notifications')
		self.interface = dbus.Interface(self.object,dbus_interface='org.freedesktop.Notifications')
	except:
		pass

        self.connection = conic.Connection()
        self.connection.set_property("automatic-connection-events", True)
        self.connection.connect("connection-event", self.connection_cb)

	self.bus = dbus.SystemBus()

        self.timer = None
        self.timeout = 0

 	self.connection_name = ""
	self.ip_address = ""

        self.button_title_text = "PPPoE connection"
	
	self.dialling = False

        self.button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.button.set_style(hildon.BUTTON_STYLE_PICKER)
        self.button.set_alignment(0.2,0.5,1,1)
        image = gtk.image_new_from_icon_name("pppoe-dialer", gtk.ICON_SIZE_BUTTON)
        self.button.set_image(image)
        self.button.set_image_position(gtk.POS_LEFT)

        self.button.connect("clicked", self.button_clicked_event)
        
        self.status_area_icon = gtk.gdk.pixbuf_new_from_file_at_size("/opt/pppoe-dialer/pppoe-dialer-status.png", 18, 18)
	self.status_area_dialling_icon = gtk.gdk.pixbuf_new_from_file_at_size("/opt/pppoe-dialer/pppoe-dialling-status.png", 18, 18)

        self.update_button(None)
        self.add(self.button)
        self.show_all()

	self.monitor_connection()
	#self.button_clicked_event(None)
    
    def button_clicked_event(self,widget):
	log("button clicked")
        self.update_button(None)

        parentDialog = gtk.Dialog(parent=None)
        info = gtk.VBox()

	global ui
	ui = pppoeui(parentDialog)

	dialButton = gtk.Button("Dial a connection")
	dialButton.connect("clicked", ui.on_dial_account)

	info.pack_start(dialButton, True, False)

	disconnectButton = gtk.Button("Disconnect")
	disconnectButton.connect("clicked", ui.on_disconnect_account)

	info.pack_start(disconnectButton, True, False)

	statusButton = gtk.Button("Current connection status")
	statusButton.connect("clicked", ui.on_conn_status)

	info.pack_start(statusButton, True, False)

	aboutButton = gtk.Button("About...")
	aboutButton.connect("clicked", ui.show_about)

	info.pack_start(aboutButton, True, False)

	parentDialog.vbox.pack_start(info, False, False)
	parentDialog.set_title("PPPoE Dialer")

	parentDialog.show_all()
	#dialog.run()
	parentDialog.connect("response", self.response_cb)
	#dialog.connect("destroy", self.destroy_cb)

    def response_cb(self, dialog, response_id):
	self.update_button(None)
	#dialog.destroy()

    def destroy_cb(self, data):
	self.update_button(None)

    def update_button(self, data):
        log("update_button")
	if self.dialling == False:
		active, connection_name = self.conn_status("silent")
		if active == True:
		    log("connected via pppoe")
		    self.button.set_text(self.button_title_text, "Connected to "+connection_name)
		    self.set_status_area_icon(self.status_area_icon)
		else:
		    log("no pppoe connections")
		    self.button.set_text(self.button_title_text, 'Not Connected')
		    self.set_status_area_icon(None)

    def connection_cb(self, connection, event):
	status = event.get_status()
	account_ssid = None
	account_name = None
	bearer = str(event.get_bearer_type())
	client = gconf.client_get_default()
	if status == conic.STATUS_CONNECTED and bearer == "WLAN_INFRA":
		iap_id = event.get_iap_id()
		ssid = connection.get_iap(iap_id).get_name()
		pppoe_acc_name = None
		try:
			pppoe_acc_name = client.get_string('/system/osso/connectivity/IAP/'+iap_id+'/pppoe_account')
		except:
			pass
		log("wlancon:ssid: "+str(ssid)+", pppoe_accname: "+str(pppoe_acc_name))
		if pppoe_acc_name is not None:
			pppoe_acc_name = str(pppoe_acc_name)
			pppoe_acc_conf = "/etc/ppp/connections/" + pppoe_acc_name
			log('checking if '+pppoe_acc_conf+' exists')
			retVal = os.system('sudo /opt/pppoe-dialer/pppoe-dialer checkaccount %s'% (pppoe_acc_name) )
			if retVal == 0:
				log("connection conffile "+pppoe_acc_name+" exists")
				active, connection_name = self.conn_status("silent")
				if active == False:
					if self.dialling == False:
						log("attempting to dial "+pppoe_acc_name+" (autostart)")
						self.dialAccount(pppoe_acc_name)
			else:
				log(pppoe_acc_conf+' does not exist')

	elif status == conic.STATUS_DISCONNECTED:
		self.disconnect_account("silent")
	#elif status == conic.STATUS_DISCONNECTING:
	#	self.disconnect_account("silent")
	self.update_button(None)

    def dialAccount(self, connection_name):
	if self.dialling == False:
		#first disconnect any existing pppoe connections
		self.disconnect_account("silent")
		self.set_status_area_icon(None)
		task = self.my_task(connection_name)
		gobject.idle_add(task.next)
		self.dialling = True

    def my_task(self, connection_name):
	#self.interface.SystemNoteInfoprint("Attempting to connect to %s..." % connection_name)
	self.button.set_text(self.button_title_text, 'Connecting to '+connection_name)
	self.set_status_area_icon(self.status_area_dialling_icon)
	toggle = False
	percent = 0.0
	retVal = 1
	t = 0
	os.system("sudo /opt/pppoe-dialer/pppoe-dialer connect %s" % connection_name)
	while percent < 100.0:
		time.sleep(2)
		retVal = os.system("sudo /opt/pppoe-dialer/pppoe-dialer status %s" % connection_name)
	    	#print >>sys.stderr, "dialAccount: t is %d" % t
		if retVal == 0:
			percent = 100.0
		else:
			percent = percent + 5.56
			#why 5.56?
			#we assume total wait time is 36 sec
			#increment in 2 sec (sleep 2)
			#hence - 36/2 = 18; 100/18 = 5.56
		# here we update parts of UI
		t = t + 1
		# there's more work, return True
		yield True

	retVal = os.system("sudo /opt/pppoe-dialer/pppoe-dialer status %s" % connection_name)
	if retVal == 0:
		#Registering connection..
		os.system("sudo /opt/pppoe-dialer/pppoe-dialer post-connect %s" % connection_name)
		#"Success."
		self.set_status_area_icon(self.status_area_icon)
		percent = 100.0
		if self.interface is not None:
			self.interface.SystemNoteInfoprint("Connected to %s." % connection_name)
	else:
		#Failed
		self.set_status_area_icon(None)
		if self.interface is not None:
			self.interface.SystemNoteInfoprint("Failed to connect to %s." % connection_name)

	self.dialling = False
	self.update_button(None)
    	# no more work, return False
    	yield False

    def monitor_connection(self):
    	log('in monitor connection')
    	#monitor for /etc/resolv.conf changes
	#self.watch_resolv_conf()
	
	#monitor for interface ppp0 interface presence changes
	self.bus.add_signal_receiver(self.device_added_callback,
					 "DeviceAdded",
					 "org.freedesktop.Hal.Manager",
					 "org.freedesktop.Hal",
					 "/org/freedesktop/Hal/Manager")
	log('monitoring added devices')
	self.bus.add_signal_receiver(self.device_removed_callback,
					 "DeviceRemoved",
					 "org.freedesktop.Hal.Manager",
					 "org.freedesktop.Hal",
					 "/org/freedesktop/Hal/Manager")
	log('monitoring removed devices')

    def udi_to_device(self, udi):
        return self.bus.get_object("org.freedesktop.Hal", udi)

    def device_added_callback(self, udi):
	log('device added')
	try:
		log("Added:" + str(udi))
		#print "Added: %s" % str(udi)
		device = self.udi_to_device(udi)
		log("Device:" + str(device))
		#print "Device: %s" % str(device)
		d_object = self.bus.get_object('org.freedesktop.Hal',udi)
		d_interface = dbus.Interface(d_object,'org.freedesktop.Hal.Device')
		properties = d_interface.GetAllProperties()
	        if "ppp" in (str(properties.get('net.interface'))):
	            log("ppp0 created? Calling update button")
        	    time.sleep(4)
        	    self.update_button(None)
	except:
		pass

    def device_removed_callback(self, udi):
	log('device removed')
	try:
		log("Removed:" + str(udi))
		device = self.udi_to_device(udi)
		log("Device:" + str(device))
        	if "net_computer" in (str(udi)):
			log("ppp0/wlan0 removed? Calling update button")
			time.sleep(4)
	        	self.update_button(None)
	except:
		pass

    '''
    def watch_resolv_conf(self):
	wm = pyinotify.WatchManager()
	mask = pyinotify.IN_DELETE | pyinotify.IN_CLOSE_WRITE
	allevents = pyinotify.ALL_EVENTS

	#notifier = pyinotify.ThreadedNotifier(wm, EventHandler())
	notifier = pyinotify.ThreadedNotifier(wm, self)
	notifier.start()

	wdd = wm.add_watch('/etc', mask, recursive=False)

	#wm.rm_watch(wdd.values())

    def process_IN_CLOSE_WRITE(self, event):
	#print "Created:", os.path.join(event.path, event.name)
	#self.archive.addFiles(os.path.join(event.path, event.name))
	if "resolv.conf" in str(event.name):
		log('resolv.conf created? calling update button')
		self.update_button(None)
  
    def process_IN_DELETE(self, event):
	#print "Modified:", os.path.join(event.path, event.name)
	#self.archive.addFiles(os.path.join(event.path, event.name))
	if "resolv.conf" in str(event.name):
		log('resolv.conf deleted? calling update button')
		self.update_button(None)
    '''

    def conn_status(self, button):
	silent = False
	if button.find("silent") > -1:
		silent = True
	connCount = 0
	line = ""
        p = subprocess.Popen('ls -1 /var/run/*-pppoe.pid', shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
        for ln in p.stdout.readlines():
	    line = ln[0:-1]
	    connCount = connCount + 1
        retval = p.wait()

	if connCount > 1:	#problem - disconnect all connections then
		print >> sys.stderr, "more than one pppoe pid?"
		self.disconnect_account("silent")
		if silent:
			return [False, None]
		else:
			self.bannerDialog("Currently not connected to any PPPoE account.")
	elif connCount == 1:
		connection_name = ""
		x = line.find("-pppoe.pid")
		if x > 0:
		    line = line.replace("/var/run/","")
		    line = line.replace("-pppoe.pid","")
		    connection_name = line
		    p = subprocess.Popen('sudo /opt/pppoe-dialer/pppoe-dialer status '+line, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
		    for line in p.stdout.readlines():
			line = line[0:-1]
		    ret = p.wait()
		    if ret == 0:
			items = line.split(";")
		    	interface = items[0]
			ipaddress = items[1]
			if silent:
				return [True, connection_name]
			else:
			        msg = "Currently connected to "+connection_name+".\n         Interface: "+items[0]+"\n    IP Address: "+items[1]
			    	self.bannerDialog(msg)
		    else:
			#can not figure out which account is connected. disconnect all
			self.disconnect_account("silent")
			if silent:
				return [False, None]
			else:
				self.bannerDialog("Currently not connected to any PPPoE account.")
		else:
		    if silent:
			return [False, None]
		    else:
		        self.bannerDialog("Currently not connected to any PPPoE account.")

    def disconnect_account(self, button):
	connCount = 0
        p = subprocess.Popen('ls -1 /var/run/*-pppoe.pid', shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
        for line in p.stdout.readlines():
	    line = line[0:-1]
	    line = line.replace("/var/run/","")	
	    x = line.find("-pppoe.pid")
	    if x > 0:
		    connection_name = line[0:x]
		    os.system("sudo /opt/pppoe-dialer/pppoe-dialer disconnect %s" % connection_name)
		    connCount = connCount + 1
        retval = p.wait()

    def last_conn_details(self):
	gotDetails = False
	line = ""
	if os.path.exists("/tmp/lastPPPOEConnection"):
		p = subprocess.Popen('cat /tmp/lastPPPOEConnection', shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
		for ln in p.stdout.readlines():
		    line = ln[0:-1]
		    x = line.find("PPPoE_#")
		    if x > 0:
			    gotDetails = True
			    break
		retval = p.wait()
	return [gotDetails, line]
    
hd_plugin_type = pppoe_dialer_applet

# The code below is just for testing purposes.
# It allows to run the widget as a standalone process.
if __name__ == "__main__":
    import gobject
    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id="plugin_id")
    obj.show_all()
    gtk.main()


