import os, sys
import subprocess
import time
import gtk
import gobject
import logging
import gconf
import hildon

import conic

gobject.threads_init()

def settingsDialog():
	mgrui = pppoemgrui()

class pppoemgrui(object):
    def __init__(self):
        parentDialog = gtk.Dialog()
        info = gtk.VBox()

	self.ui = pppoeui(parentDialog)

	dialButton = gtk.Button("Dial a connection")
	dialButton.connect("clicked", self.ui.on_dial_account)

	info.pack_start(dialButton, True, False)

	disconnectButton = gtk.Button("Disconnect")
	disconnectButton.connect("clicked", self.ui.on_disconnect_account)

	info.pack_start(disconnectButton, True, False)

	newButton = gtk.Button("Create a connection account")
	newButton.connect("clicked", self.ui.on_new_account)

	info.pack_start(newButton, True, False)

	editButton = gtk.Button("Edit an account")
	editButton.connect("clicked", self.ui.on_edit_account)

	info.pack_start(editButton, True, False)

	statusButton = gtk.Button("Current connection status")
	statusButton.connect("clicked", self.ui.on_conn_status)

	info.pack_start(statusButton, True, False)

	aboutButton = gtk.Button("About...")
	aboutButton.connect("clicked", self.ui.show_about)

	info.pack_start(aboutButton, True, False)

	parentDialog.vbox.pack_start(info, False, False)
	parentDialog.set_title("PPPoE Accounts Manager")
	parentDialog.show_all()
	parentDialog.run()


class DialDialog(object):
    def __init__(self, connection_name):
	self.connection_name = connection_name

	self.ui = pppoeui()

        self.dialog = gtk.Dialog()
	###Dialling UI

	self.dialling = False
        pcont = gtk.VBox()
        self.progress = gtk.ProgressBar()
        pcont.pack_start(self.progress, True, False)

	dialButton = gtk.Button("Dial")
	dialButton.connect("clicked",self.on_dialAccount)

	self.dialStatus = gtk.Label("Select 'Dial' to dial.")

	pcont.pack_start(dialButton, True, False)
        pcont.pack_start(self.dialStatus, True, False)

        self.progress.set_fraction(0)
        self.progress.set_orientation(gtk.PROGRESS_LEFT_TO_RIGHT)

	#END DIAL

	self.dialog.vbox.pack_start(pcont, False, False)
	self.dialog.set_title("Dial %s" % self.connection_name)
	self.dialog.show_all()
	response = self.dialog.run()
	print "response is %s" % str(response)
	if response == gtk.RESPONSE_DELETE_EVENT or response == gtk.RESPONSE_CANCEL:
			self.ui.on_disconnect_account("silent")
			self.dialog.hide()
	self.dialog.hide()

    def on_dialAccount(self, userData):
	if self.dialling == False:
		#first disconnect any existing pppoe connections
		self.progress.set_text("Disconnecting any active PPPoE connections..")
		self.ui.on_disconnect_account("silent")
		task = self.my_task(userData)
		gobject.idle_add(task.next)
		self.dialling = True

    def my_task(self, data):
	percent = 0.0
	retVal = 1
	t = 0
	os.system("sudo /opt/pppoe-dialer/pppoe-dialer connect %s" % self.connection_name)
	self.dialStatus.set_text("")
	while percent < 100.0:
		time.sleep(2)
		retVal = os.system("sudo /opt/pppoe-dialer/pppoe-dialer status %s" % self.connection_name)
	    	#print >>sys.stderr, "dialAccount: t is %d" % t
		if retVal == 0:
			percent = 100.0
		else:
			percent = percent + 5.56
			#why 5.56?
			#we assume total wait time is 36 sec
			#increment in 2 sec (sleep 2)
			#hence - 36/2 = 18; 100/18 = 5.56
		self.progress.set_text("Dialling...") # here we update parts of UI
		self.progress.set_fraction(percent/100.0)
		t = t + 1
		# there's more work, return True
		yield True

	retVal = os.system("sudo /opt/pppoe-dialer/pppoe-dialer status %s" % self.connection_name)
	if retVal == 0:
		self.progress.set_text("Registering connection..")
		os.system("sudo /opt/pppoe-dialer/pppoe-dialer post-connect %s" % self.connection_name)
		self.progress.set_text("Success.")
		self.ui.bannerDialog("Connected to %s." % self.connection_name)
		self.progress.set_fraction(1)
		self.dialog.hide()
	else:
		self.progress.set_text("Failed.")
		self.progress.set_fraction(0)

	self.dialling = False
    	# no more work, return False
    	yield False

    def on_complete(self, status):
    	print >>sys.stderr, "on complete"
        hildon.hildon_gtk_window_set_progress_indicator(self.dialog, 0)
        if status:
            self.progress.set_fraction(1)
            self.progress.set_text("Connected.")
        else:
            self.progress.set_fraction(0)
            self.progress.set_text("Connection failed / timed out.")

    def on_progress(self, percent):
    	print >>sys.stderr, "on progress %f" % percent	
    	print >>sys.stderr, "on progress: setting fraction: %f" % (percent/100.0)	
        self.progress.set_fraction(percent/100.0)

class NewAccountDialog(object):
  
    def __init__(self):

	self.ui = pppoeui()

        self.notebook = gtk.Notebook()

	self.selected_wifiNetworks = ""
	self.selected_wifiNetworkIdx = ""
	self.wifiProfilesExist = False

        page1 = gtk.Table (1, 2, False)
        page1.set_row_spacings(10)
        page1.set_col_spacings(10)
        self.newAccName = hildon.Entry(gtk.HILDON_SIZE_AUTO)
	self.newAccName.set_input_mode(gtk.HILDON_GTK_INPUT_MODE_ALPHA | gtk.HILDON_GTK_INPUT_MODE_NUMERIC)
        page1.attach(gtk.Label("Enter a name for this account"), 0, 1, 0, 1);
        page1.attach(self.newAccName, 0, 1, 1, 2);
  
        page2 = gtk.Table (1, 2, False)
        page2.set_row_spacings(10)
        page2.set_col_spacings(10)
        self.newAccUserName = hildon.Entry(gtk.HILDON_SIZE_AUTO)
	#self.newAccUserName.set_input_mode(gtk.HILDON_GTK_INPUT_MODE_ALPHA | gtk.HILDON_GTK_INPUT_MODE_NUMERIC)
        page2.attach(gtk.Label("Enter a username for this account \n(e.g. user@dslprovider) "), 0, 1, 0, 1);
        page2.attach(self.newAccUserName, 0, 1, 1, 2);

        page3 = gtk.Table (1, 3, False)
        page3.set_row_spacings(10)
        page3.set_col_spacings(10)
        self.newAccPwd = hildon.Entry(gtk.HILDON_SIZE_AUTO)
	self.newAccPwd.set_visibility(True)
	self.newAccPwd.set_input_mode(gtk.HILDON_GTK_INPUT_MODE_INVISIBLE | gtk.HILDON_GTK_INPUT_MODE_ALPHA | gtk.HILDON_GTK_INPUT_MODE_NUMERIC)
        self.newAccPwdConfirm = hildon.Entry(gtk.HILDON_SIZE_AUTO)
        self.newAccPwdConfirm.set_visibility(True)
	self.newAccPwdConfirm.set_input_mode(gtk.HILDON_GTK_INPUT_MODE_INVISIBLE | gtk.HILDON_GTK_INPUT_MODE_ALPHA | gtk.HILDON_GTK_INPUT_MODE_NUMERIC)
        page3.attach(gtk.Label("Enter the password for this account"), 0, 1, 0, 1);
        page3.attach(self.newAccPwd, 0, 1, 1, 2);
        page3.attach(gtk.Label("Re-type the password:"), 0, 1, 2, 3);
        page3.attach(self.newAccPwdConfirm, 0, 1, 3, 4);

        page4 = gtk.Label("Select 'Next' to complete \nAccount creation.")

	#create complete notification
        self.page5 = gtk.Label("")

	#choose wifi networks to auto-connect for
	self.page6, self.wifiProfilesExist = self.ui.list_wifinetworks(self.selection_changed)

	self.page7 = gtk.Label("")
	self.page8 = gtk.Label("")

        self.notebook.append_page(page1)
        self.notebook.append_page(page2)
        self.notebook.append_page(page3)
        self.notebook.append_page(page4)
        self.notebook.append_page(self.page5)
        self.notebook.append_page(self.page6)
        self.notebook.append_page(self.page7)
        self.notebook.append_page(self.page8)

        self.dialog = hildon.WizardDialog(None, "Create a new account", self.notebook)
        self.notebook.connect("switch-page", self.on_switch)
        self.dialog.set_forward_page_func(self.forward_func)

    def on_switch(self, notebook, page, num):
    	print >>sys.stderr, "Page %d" % num
	if num == 5:
		connection_name = self.newAccName.get_text()
		#if self.selector is not None and networkProfiles is not None:
		print "select items in list"
		for i in range(len(networkProfiles)):
		    pppoe_acc_name = networkProfiles[i][1]
		    print "networkProfiles[%d][1] = %s" % (i, pppoe_acc_name)
		    if pppoe_acc_name == connection_name:
			    print "pppoe_acc_name %s matches connection_name %s" % (pppoe_acc_name, connection_name)
			    selector.select_iter(0, selector.get_model(0).get_iter(i), False)
		return True
    	return True

    def forward_func(self, notebook, current, userdata):
	if current == 0:	#enter account name
	   if len(self.newAccName.get_text()) != 0 :
		retVal = os.system('sudo /opt/pppoe-dialer/pppoe-dialer checkaccount %s'% (self.newAccName.get_text()) )
		if retVal == 0:
			self.ui.bannerDialog("Account with this name already exists.")
			return False
	elif current == 1:	#enter user name
	   if len(self.newAccUserName.get_text()) != 0 :
		tmpString = (self.newAccUserName.get_text())
		tmpString = tmpString.replace("@","", 1)
		tmpString = tmpString.replace(".","")	
		tmpString = tmpString.replace("_","")
		tmpString = tmpString.replace("-","")
		tmpString = tmpString.replace(".","")
		if tmpString.isalnum():
			retVal = os.system('sudo /opt/pppoe-dialer/pppoe-dialer checkuser %s' % (self.newAccUserName.get_text()) )
			if retVal == 0:
				self.ui.bannerDialog("An account with this username already exists.")
			   	return False
		else:
		    	self.ui.bannerDialog("Invalid characters entered (only '.', one instance of '@' \nand alphanumeric chars allowed.")
			return False
	elif current == 2: 	#enter password
   	   if len(self.newAccPwd.get_text()) != 0 :
		   if ((self.newAccPwd.get_text().lower()) != (self.newAccPwdConfirm.get_text().lower())):
			self.ui.bannerDialog("Passwords do not match")
			return False
	elif current == 3:	#Create account
	   connection_name = self.newAccName.get_text()
	   retVal = os.system('sudo /opt/pppoe-dialer/pppoe-dialer checkaccount %s' % (connection_name) )
	   if retVal == 0:
		   self.page5.set_text("Account: %s\n could not be created (already exists)." % connection_name )
	   else:
		   service_name = self.newAccUserName.get_text()
	    	   print >>sys.stderr, "service_name  is %s" % service_name
		   if service_name.count("@") == 1:
			service_name = (service_name.split('@'))[1]
		    	print >>sys.stderr, "service_name %s consists of 1x @" % service_name
		   else:
			service_name = ""
		    	print >>sys.stderr, "service_name %s consists of more than one or none of @" % service_name
	 	   retVal = os.system("sudo /opt/pppoe-dialer/pppoe-dialer newaccount %s %s %s %s" % (self.newAccUserName.get_text(), connection_name, service_name, self.newAccPwd.get_text()))
		   if retVal == 0:
			self.page5.set_text("Account: %s successfully created. \nPress 'Next' to select wireless networks\nfor which %s should\nautomatically connect;\n\nOtherwise select 'Finish' to complete and quit." % (connection_name, connection_name) )
			#self.dialog.hide()
			#self.ui.bannerDialog("Account %s successfully created." % (connection_name))
		   else:
			self.page5.set_text("Account: %s\ncould not be created." % connection_name )
	   	   return True
	elif current == 4:
		if self.wifiProfilesExist == False:
			self.ui.bannerDialog("No Wireless Networks have been setup or connected to.\nPlease setup a wireless network or connect to one before configuring this connection for autostart.")
			self.dialog.hide()
	elif current == 5:
		connection_name = self.newAccName.get_text()
		wifiNetworks = ""
		num = 0
		if self.selectedIAPs is not None:
			num = len(self.selectedIAPs)

		if num > 3:
			self.page7.set_text("You selected "+num+"\nWireless Networks\nFor which "+connection_name+"\nautomatically starts.\n\nPress 'Next' to confirm.")
		elif num > 0:
			txt = "You selected the following\nWireless Networks\nFor which "+connection_name+"\nautomatically starts:\n\n"
			count=0
			for selectedIAP in self.selectedIAPs:
				wifiNetworks = wifiNetworks + "* " + str(selectedIAP) + "\n"
				count = count + 1
				if count > 2:
					break
			txt = txt + wifiNetworks
			txt = txt + "\nPress 'Next' to confirm."
			self.page7.set_text(txt)
		else:
			self.page7.set_text("You have selected no\nWireless Networks\nFor which "+connection_name+"\nshould start.\n\nPress 'Next' to confirm this choice.")

		return True
	elif current == 6:	#apply selections:
		connection_name = self.newAccName.get_text()
		client = gconf.client_get_default()

		noIAPSelected = False
		if self.selectedIAPs is None:
			noIAPSelected = True
			self.selectedIAPs = [""]	# Dummy value

		for IAP in networkProfiles:
			pppoe_key='/system/osso/connectivity/IAP/'+IAP[2]+'/pppoe_account'
			if IAP[0] in self.selectedIAPs:
				try:
					client.set_string(pppoe_key, connection_name)
				except:
					pass
			else:
				pppoe_accname = None
				try:
					pppoe_accname = client.get_string(pppoe_key)
					if connection_name == str(pppoe_accname):
							client.unset(pppoe_key)
				except:
					pass

		if noIAPSelected == True:
			self.selectedIAPs = None

		if self.selectedIAPs is not None:
			self.page8.set_text("Autostart changes for %s have been applied." % (connection_name))
			self.ui.bannerDialog("Autostart changes for %s have been applied." % (connection_name))
		else:
			self.page8.set_text("%s shall not automatically connect for any network." % (connection_name))
			self.ui.bannerDialog("%s shall not automatically connect for any network." % (connection_name))
		self.dialog.hide()
		return True
	return True

    def show_all(self):
        self.dialog.show_all()

    def run(self):
        self.dialog.run()

    def hide(self):
	self.dialog.hide()

    def selection_changed(self, selector, user_data):
	#can only get first selected item from multiple-selectable list, not without doing the stuff below
	conns = str(selector.get_selected_rows(0))
	idx=0
	count=0
	self.selectedIAPs = []
	self.selectedIAPIDs = []
	for networkProfile in networkProfiles:
		index="("+str(idx)+",)"
		if index in conns:
			self.selectedIAPs.append(networkProfile[0])
			self.selectedIAPIDs.append(networkProfile[2])
			count = count + 1
		idx = idx + 1
	
	if count == 0:
		self.selectedIAPs = None
		self.selectedIAPIDs = None

class EditAccountDialog(object):
    def __init__(self):

	self.ui = pppoeui()

        self.notebook = gtk.Notebook()

	self.selected_wifiNetworks = ""
	self.selected_wifiNetworkIdx = ""

        self.page0 = self.list_connections()

        self.page1 = gtk.Table (1, 2, False)
        self.page1.set_row_spacings(10)
        self.page1.set_col_spacings(10)
	delButton = gtk.Button("Delete account")
	#delButton.set_text("Delete", "Delete account")        
        #delButton.set_label("Delete")        
	delButton.connect('clicked', self.on_delAccount)
	self.delAccStatus = gtk.Label("")
	self.page1.attach(gtk.Label("Select 'Delete' to delete the account,\nor 'Next' to continue editing this account."), 0, 1, 0, 1);
        self.page1.attach(delButton, 0, 1, 1, 2);
	self.page1.attach(self.delAccStatus, 0, 1, 2, 3)
  
        page2 = gtk.Table (1, 2, False)
        page2.set_row_spacings(10)
        page2.set_col_spacings(10)
        self.accUserName = hildon.Entry(gtk.HILDON_SIZE_AUTO)
	#self.accUserName.set_input_mode(gtk.HILDON_GTK_INPUT_MODE_ALPHA | gtk.HILDON_GTK_INPUT_MODE_NUMERIC)
        page2.attach(gtk.Label("Update username for this account \n(e.g. user@dslprovider) "), 0, 1, 0, 1);
        page2.attach(self.accUserName, 0, 1, 1, 2);

        page3 = gtk.Table (1, 3, False)
        page3.set_row_spacings(10)
        page3.set_col_spacings(10)
        self.accPwd = hildon.Entry(gtk.HILDON_SIZE_AUTO)
	self.accPwd.set_visibility(True)
	self.accPwd.set_input_mode(gtk.HILDON_GTK_INPUT_MODE_INVISIBLE | gtk.HILDON_GTK_INPUT_MODE_ALPHA | gtk.HILDON_GTK_INPUT_MODE_NUMERIC)
        self.accPwdConfirm = hildon.Entry(gtk.HILDON_SIZE_AUTO)
        self.accPwdConfirm.set_visibility(True)
	self.accPwdConfirm.set_input_mode(gtk.HILDON_GTK_INPUT_MODE_INVISIBLE | gtk.HILDON_GTK_INPUT_MODE_ALPHA | gtk.HILDON_GTK_INPUT_MODE_NUMERIC)
        page3.attach(gtk.Label("Enter the password for this account"), 0, 1, 0, 1);
        page3.attach(self.accPwd, 0, 1, 1, 2);
        page3.attach(gtk.Label("Re-type the password:"), 0, 1, 2, 3);
        page3.attach(self.accPwdConfirm, 0, 1, 3, 4);

        page4 = gtk.Label("Select 'Next' to complete making \nAccount changes.")

        self.page5 = gtk.Label("")

        self.page6 = gtk.Table (1, 2, False)
        self.page6.set_row_spacings(10)
        self.page6.set_col_spacings(10)
	removeButton = gtk.Button("Disable Autostart")
	removeButton.connect('clicked', self.on_removeAllAccountAutoRules)
	self.disableAccAutoStatus = gtk.Label("")
	self.page6.attach(gtk.Label("Press 'Disable Autostart' twice to disable account\nfrom auto-connecting for any Wireless Network;\nOr press 'Next' to edit\nfor specific networks."), 0, 1, 0, 1);
        self.page6.attach(removeButton, 0, 1, 1, 2);
	self.page6.attach(self.disableAccAutoStatus, 0, 1, 2, 3)

	self.page7, self.wifiProfilesExist = self.ui.list_wifinetworks(self.selection_changed)

	self.page8 = gtk.Label("")
	self.page9 = gtk.Label("")

        self.notebook.append_page(self.page0)
	self.notebook.append_page(self.page1)
        self.notebook.append_page(page2)
        self.notebook.append_page(page3)
        self.notebook.append_page(page4)
        self.notebook.append_page(self.page5)
	self.notebook.append_page(self.page6)
	self.notebook.append_page(self.page7)
	self.notebook.append_page(self.page8)
	self.notebook.append_page(self.page9)

        self.dialog = hildon.WizardDialog(None, "Edit account", self.notebook)
        self.notebook.connect("switch-page", self.on_switch)
        self.dialog.set_forward_page_func(self.forward_func)

    def list_connections(self):
    	# Create a picker button
    	picker_button = hildon.PickerButton(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
 
    	# Set a title to the button 
    	picker_button.set_title("Select an account.")

    	# Create a touch selector entry
    	selector = hildon.TouchSelectorEntry(text=True)
 
	connCount = 0
        p = subprocess.Popen('sudo /opt/pppoe-dialer/pppoe-dialer listaccounts', shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
        for line in p.stdout.readlines():
	    line = line[0:-1]
            selector.append_text(line),
	    connCount = connCount + 1
        retval = p.wait()

	if connCount == 0 :
		self.ui.bannerDialog("No accounts exist.  Create an account first.")
		self.hide()

    	# Attach the touch selector to the picker button
    	picker_button.set_selector(selector)

	return picker_button

    def on_switch(self, notebook, page, num):
    	print >>sys.stderr, "Page %d" % num
	if num == 7:
		connection_name = self.page0.get_value()
		#if self.selector is not None and networkProfiles is not None:
		print "select items in list"
		for i in range(len(networkProfiles)):
		    pppoe_acc_name = networkProfiles[i][1]
		    print "networkProfiles[%d][1] = %s" % (i, pppoe_acc_name)
		    if pppoe_acc_name == connection_name:
			    print "pppoe_acc_name %s matches connection_name %s" % (pppoe_acc_name, connection_name)
			    selector.select_iter(0, selector.get_model(0).get_iter(i), False)
		return True
    	return True

    def forward_func(self, notebook, current, userdata):
	if current == 0:	#get account name
	   if len(self.page0.get_value()) != 0 :
	    	print >>sys.stderr, "account selected: %s" % (self.page0.get_value())
 	        retVal = os.system('sudo /opt/pppoe-dialer/pppoe-dialer checkaccount %s' % (self.page0.get_value()) )
	        if retVal == 1:
		   self.hide()
		   return False
	elif current == 1:	#delete page
		line=""
        	p = subprocess.Popen('sudo /opt/pppoe-dialer/pppoe-dialer getuser %s' % self.page0.get_value(), shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
        	for line in p.stdout.readlines():                              
        	    line = line[0:-1]
        	retval = p.wait() 
		tmpString = line.replace("USER=","")
		tmpString = tmpString.replace("'","")
		self.accUserName.set_text(tmpString)

	elif current == 2:	#enter user name
	   if len(self.accUserName.get_text()) != 0 :
		tmpString = (self.accUserName.get_text())
		tmpString = tmpString.replace("@","", 1)
		tmpString = tmpString.replace(".","")	
		tmpString = tmpString.replace("_","")
		tmpString = tmpString.replace("-","")
		tmpString = tmpString.replace(".","")
		if tmpString.isalnum():
			retVal = os.system('grep \"%s\" /etc/ppp/connections/*' % (self.accUserName.get_text()) )
			if retVal == 0:
				self.ui.bannerDialog("An account with this username already exists.")
			   	return False
		else:
			self.ui.bannerDialog("Invalid characters entered (only '.', one instance of '@' \nand alphanumeric chars allowed.")
			return False

        	p = subprocess.Popen('sudo /opt/pppoe-dialer/pppoe-dialer getpwd %s' % self.accUserName.get_text(), shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
        	for line in p.stdout.readlines():
        	    line = line[0:-1]                                          
        	retval = p.wait() 
		self.accPwd.set_text(line)
		self.accPwdConfirm.set_text(line)

	elif current == 3: 	#enter password
	   if len(self.accPwd.get_text()) != 0 :
		   if ((self.accPwd.get_text().lower()) != (self.accPwdConfirm.get_text().lower())):
			self.ui.bannerDialog("Passwords do not match")
			return False

	elif current == 4:	#Save account
	   connection_name = self.page0.get_value()
	   retVal = os.system('sudo /opt/pppoe-dialer/pppoe-dialer checkaccount %s' % (connection_name) )
	   if retVal == 1:
		   self.page5.set_text("Account: %s\n could not be modified." % connection_name )
	   else:
		   service_name = self.accUserName.get_text()
	    	   print >>sys.stderr, "service_name  is %s" % service_name
		   if service_name.count("@") == 1:
			service_name = (service_name.split('@'))[1]
		    	print >>sys.stderr, "service_name %s consists of 1x @" % service_name
		   else:
			service_name = ""
		    	print >>sys.stderr, "service_name %s consists of more than one or none of @" % service_name
		   retVal = os.system("sudo /opt/pppoe-dialer/pppoe-dialer editaccount %s %s %s %s" % (self.accUserName.get_text(), connection_name, service_name, self.accPwd.get_text()))
		   if retVal == 0:
			#self.ui.bannerDialog("Account %s successfully modified." % (connection_name))
			self.page5.set_text("Account: %s\nhas been successfully modified.\nPress 'Next' to change\nautomatic connection rules for %s.\n\nOtherwise, press 'Finish'\nto complete and exit." % (connection_name, connection_name) )
			#self.dialog.hide()
		   else:
			self.page5.set_text("Account: %s\ncould not be modified." % connection_name )
	   	   return True

	elif current == 5:
		if self.wifiProfilesExist == False:
			self.ui.bannerDialog("No Wireless Networks have been setup or connected to.\nPlease either setup a wireless network , or connect to one before configuring this connection for autostart.")
			self.dialog.hide()

	elif current == 7:
		connection_name = self.page0.get_value()
		wifiNetworks = ""
		num = 0
		if self.selectedIAPs is not None:
			num = len(self.selectedIAPs)

		if num > 3:
			self.page8.set_text("You selected "+num+"\nWireless Networks\nFor which "+connection_name+"\nautomatically starts.\n\nPress 'Next' to confirm.")
		elif num > 0:
			txt = "You selected the following\nWireless Networks\nFor which "+connection_name+"\nautomatically starts:\n\n"
			count=0
			for selectedIAP in self.selectedIAPs:
				wifiNetworks = wifiNetworks + "* " + str(selectedIAP) + "\n"
				count = count + 1
				if count > 2:
					break
			txt = txt + wifiNetworks
			txt = txt + "\nPress 'Next' to confirm."
			self.page8.set_text(txt)
		else:
			self.page8.set_text("You have selected no\nWireless Networks\nFor which "+connection_name+"\nshould start.\n\nPress 'Next' to confirm this choice.")

		return True

	elif current == 8:	#apply selections:
		connection_name = self.page0.get_value()
		client = gconf.client_get_default()

		noIAPSelected = False
		if self.selectedIAPs is None:
			noIAPSelected = True
			self.selectedIAPs = [""]	# Dummy value

		for IAP in networkProfiles:
			pppoe_key='/system/osso/connectivity/IAP/'+IAP[2]+'/pppoe_account'
			if IAP[0] in self.selectedIAPs:
				try:
					client.set_string(pppoe_key, connection_name)
				except:
					pass
			else:
				pppoe_accname = None
				try:
					pppoe_accname = client.get_string(pppoe_key)
					if connection_name == str(pppoe_accname):
							client.unset(pppoe_key)
				except:
					pass

		if noIAPSelected == True:
			self.selectedIAPs = None

		if self.selectedIAPs is not None:
			self.page9.set_text("Autostart changes for %s have been applied." % (connection_name))
			self.ui.bannerDialog("Autostart changes for %s have been applied." % (connection_name))
		else:
			self.page9.set_text("%s shall not automatically connect for any network." % (connection_name))
			self.ui.bannerDialog("%s shall not automatically connect for any network." % (connection_name))
		self.dialog.hide()

		return True
	return True

    def on_delAccount(self, userData):
        retVal = os.system('sudo /opt/pppoe-dialer/pppoe-dialer checkaccount %s' % (self.page0.get_value()) )
        if retVal == 1:
	   self.ui.bannerDialog("Account %s already deleted." % (self.page0.get_value()))
	   self.hide()
	else:
		if (self.delAccStatus).get_text() == "":
			self.delAccStatus.set_text("Press again to confirm deletion.")
		else:
			connection_name = self.page0.get_value()
 			line=""                             
 			p = subprocess.Popen('sudo /opt/pppoe-dialer/pppoe-dialer getuser %s' % connection_name, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
 			for line in p.stdout.readlines():               
 			    line = line[0:-1]               
 			retval = p.wait()               
 			tmpString = line.replace("USER=","") 
			user_name = tmpString.replace("'","")			
			retVal = os.system("sudo /opt/pppoe-dialer/pppoe-dialer delaccount %s %s" % (connection_name, user_name) )
			if retVal == 0:
				self.ui.bannerDialog("Account %s has been deleted." % (connection_name))
				self.hide()
			else:
				self.delAccStatus.set_text("Account: %s\ncould not be deleted." % connection_name )

    def on_removeAllAccountAutoRules(self, userData):
    	if (self.disableAccAutoStatus).get_text() == "":
		self.disableAccAutoStatus.set_text("Press again to confirm disabling autostart.")
	else:
		connection_name = self.page0.get_value()
		client = gconf.client_get_default()
		print "attempting to disable autostart"
		for IAP in networkProfiles:
			pppoe_key='/system/osso/connectivity/IAP/'+IAP[2]+'/pppoe_account'
			print pppoe_key
			pppoe_accname = None
			try:
				pppoe_accname = client.get_string(pppoe_key)
				print str(pppoe_accname)
				if connection_name == str(pppoe_accname):
					client.unset(pppoe_key)
			except:
				pass

		self.page9.set_text("Autostart has been disabled for %s from all Wireless Network Profiles." % (connection_name))
		self.ui.bannerDialog("Autostart changes for %s have been applied." % (connection_name))
		self.dialog.hide()


    def selection_changed(self, selector, user_data):
	#can only get first selected item from multiple-selectable list, not without doing the stuff below
	conns = str(selector.get_selected_rows(0))
	idx=0
	count=0
	self.selectedIAPs = []
	self.selectedIAPIDs = []
	for networkProfile in networkProfiles:
		index="("+str(idx)+",)"
		if index in conns:
			self.selectedIAPs.append(networkProfile[0])
			self.selectedIAPIDs.append(networkProfile[2])
			count = count + 1
		idx = idx + 1
	
	if count == 0:
		self.selectedIAPs = None
		self.selectedIAPIDs = None

    def show_all(self):
        self.dialog.show_all()

    def run(self):
        self.dialog.run()

    def hide(self):
        self.dialog.hide()

class DialAccountDialog(object):
    def __init__(self):	

	self.ui = pppoeui()

        self.notebook = gtk.Notebook()

        self.pickerButton = self.list_connections()

        self.page1 = gtk.Table (1, 2, False)
        self.page1.set_row_spacings(10)
        self.page1.set_col_spacings(10)

	self.page1.attach(self.pickerButton, 0, 1, 0, 1);
        self.page1.attach(gtk.Label("Select 'Next' to dial selected account"), 0, 1, 1, 2);  

	self.notebook.append_page(self.page1)

        self.dialog = hildon.WizardDialog(None, "Dial account", self.notebook)
        self.notebook.connect("switch-page", self.on_switch)
        self.dialog.set_forward_page_func(self.forward_func)


    def list_connections(self):
    	# Create a picker button
    	picker_button = hildon.PickerButton(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
 
    	# Set a title to the button 
    	picker_button.set_title("Select an account.")

    	# Create a touch selector entry
    	selector = hildon.TouchSelectorEntry(text=True)
 
	connCount = 0
        p = subprocess.Popen('sudo /opt/pppoe-dialer/pppoe-dialer listaccounts', shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
        for line in p.stdout.readlines():
	    line = line[0:-1]
            selector.append_text(line),
	    connCount = connCount + 1
        retval = p.wait()

	if connCount == 0 :
		self.ui.bannerDialog("No accounts exist.  Create an account first.")
		#self.hide()

    	# Attach the touch selector to the picker button
    	picker_button.set_selector(selector)

	return picker_button

    def on_switch(self, notebook, page, num):
    	print >>sys.stderr, "Page %d" % num
    	return True

    def forward_func(self, notebook, current, userdata):
	if current == 0:	#get account name
		connection_name = (self.pickerButton.get_value())
		dialog = DialDialog(connection_name)
		self.dialog.hide()
		return True
	return True

    def show_all(self):
        self.dialog.show_all()

    def run(self):
        self.dialog.run()

    def hide(self):
        self.dialog.hide()

class pppoeui(object):
    def __init__(self, parentDialog=None):
        self.app = None
        self.menu = None
        self.window = None
	self.wifiProfilesExist = False
	self.parentDialog = parentDialog

    def destroy(self, widget):
        gtk.main_quit()

    def show_about(self, w):
        from about import HeAboutDialog

        response = HeAboutDialog.present(None,
                'PPPoE Dialer',
                'pppoe-dialer',
                '0.1',
                'PPPoE accounts management and dialer interface.',
                '(c) George James',
                None,
                None,
                'https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=FMSRWEJDEHNGU')

        if response == HeAboutDialog.RESPONSE_WEBSITE or response == HeAboutDialog.RESPONSE_BUGTRACKER or response == HeAboutDialog.RESPONSE_DONATE:
		try:
			self.parentDialog.destroy()
			self.destroy()
		except:	
			pass

    def open_link(self, d, url, data):
        import webbrowser
        webbrowser.open_new(url)


    def on_new_account(self, button):
        dialog = NewAccountDialog()
        dialog.show_all()
        dialog.run()
        dialog.hide()

    def on_edit_account(self, button):
        dialog = EditAccountDialog()
        dialog.show_all()
        dialog.run()
        dialog.hide()

    def on_dial_account(self, button):
        dialog = DialAccountDialog()
        dialog.show_all()
        dialog.run()
        dialog.hide()

    def on_conn_status(self, button):
	silent = False
	if str(button).find("silent") > -1:
		silent = True
	connCount = 0
	line = ""
        p = subprocess.Popen('ls -1 /var/run/*-pppoe.pid', shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
        for ln in p.stdout.readlines():
	    line = ln[0:-1]
	    connCount = connCount + 1
        retval = p.wait()

	if connCount > 1:	#problem - disconnect all connections then
		print >> sys.stderr, "more than one pppoe pid?"
		self.on_disconnect_account("silent")
		if silent:
			return [False, None]
		else:
			self.bannerDialog("Currently not connected to any PPPoE account.")
	elif connCount == 1:
		connection_name = ""
		x = line.find("-pppoe.pid")
		if x > 0:
		    line = line.replace("/var/run/","")
		    line = line.replace("-pppoe.pid","")
		    connection_name = line
		    p = subprocess.Popen('sudo /opt/pppoe-dialer/pppoe-dialer status '+line, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
		    for line in p.stdout.readlines():
			line = line[0:-1]
		    ret = p.wait()
		    if ret == 0:
			items = line.split(";")
		    	interface = items[0]
			ipaddress = items[1]
			if silent:
				return [True, connection_name]
			else:
			        msg = "Currently connected to "+connection_name+".\n         Interface: "+items[0]+"\n    IP Address: "+items[1]
			    	self.bannerDialog(msg)
		    else:
			#can not figure out which account is connected. disconnect all
			self.on_disconnect_account("silent")
			if silent:
				return [False, None]
			else:
				self.bannerDialog("Currently not connected to any PPPoE account.")
		else:
		    if silent:
			return [False, None]
		    else:
		        self.bannerDialog("Currently not connected to any PPPoE account.")

    def bannerDialog(self, msg):
        dialog = gtk.Dialog()
	info = gtk.VBox()
	msgText = gtk.Label(msg)
	info.pack_start(msgText, True, False)
	dialog.vbox.pack_start(info, False, False)
	dialog.set_title("")
	dialog.show_all()
	dialog.run()
	dialog.hide()

    def list_wifinetworks(self, callBackFunc):
	global networkProfiles
	global selector
	selector = None
	networkProfiles = [ [ None, None, None ] ]

    	# Create a picker button
    	#picker_button = hildon.PickerButton(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
 
    	# Set a title to the button 
    	#picker_button.set_title("Select networks.")

    	# Create a touch selector entry
    	selector = hildon.TouchSelectorEntry(text=True)
	selector.connect("changed", callBackFunc)
	selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_MULTIPLE)
 
	connection = conic.Connection()
	iaps = connection.get_all_iaps()
	count = 0

	client = gconf.client_get_default()

	for iap in iaps:
		#print iap
		iap_id = str(iap.get_id())
		iap_name = str(iap.get_name())
		iap_bearer = str(iap.get_bearer_type())
		if iap_bearer == "WLAN_INFRA":
			pppoe_acc_name = None
			try:
				pppoe_acc_name = client.get_string('/system/osso/connectivity/IAP/'+iap_id+'/pppoe_account')
			except:
				pass
			networkProf = [ iap_name, str(pppoe_acc_name), iap_id ]
			networkProfiles.append(networkProf)
			selector.append_text(iap_name)
			count = 1

	if count == 0 :
		self.wifiProfilesExist = False
	else:
		self.wifiProfilesExist = True
		del networkProfiles[0]

	return [selector, self.wifiProfilesExist]

    	# Attach the touch selector to the picker button
    	#picker_button.set_selector(selector)

	#return picker_button

    def on_disconnect_account(self, button):
	connCount = 0
        p = subprocess.Popen('ls -1 /var/run/*-pppoe.pid', shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
        for line in p.stdout.readlines():
	    line = line[0:-1]
	    line = line.replace("/var/run/","")	
	    x = line.find("-pppoe.pid")
	    if x > 0:
		    connection_name = line[0:x]
		    q=subprocess.Popen("sudo /opt/pppoe-dialer/pppoe-dialer disconnect "+connection_name,shell=True, stdout=None, stderr=None)
		    ret = q.wait()
		    connCount = connCount + 1
        retval = p.wait()

	x = (str(button)).find("silent")
	if x < 0:
		self.bannerDialog("All PPPoE connections terminated.")
		#not really smart, but here we assume that there is no intention to connect to an ISP immediately afterwards.
		os.system("sudo /opt/pppoe-dialer/pppoe-dialer unloadKernelModules")
		 
	#self.hide()

    def hide(self):
	b=1

if __name__=="__main__":
    settingsDialog()

