/*
 *   To use with custom executable, compile with 'OSSO_PLUGIN_EXEC_LOADER_COMMAND'
 * defined to the full path of your target executable.
 *
 * Arguments parsed to the 'CP_EXEC_LOADER_COMMAND' executable are:
 *
 *   string: application name     - This is the name of the host application.
 *   string: application version  - This is the version of the host application.
 *      int: parent xid           - This is the parent window's X11 XID.
 *
 */
#include <glib.h>
#include <gdk/gdkx.h>
#include <gtk/gtk.h>

#include <hildon-cp-plugin/hildon-cp-plugin-interface.h>

#ifndef OSSO_PLUGIN_EXEC_LOADER_COMMAND
#   define OSSO_PLUGIN_EXEC_LOADER_COMMAND "/usr/bin/python /opt/pppoe-dialer/pppoemgrui.py"
#endif

osso_return_t execute(osso_context_t *osso G_GNUC_UNUSED,
                      gpointer data,
                      gboolean user_activated G_GNUC_UNUSED)
{
  GtkWidget *parent = GTK_WIDGET(data);
  XID        xid    = gdk_x11_drawable_get_xid(gtk_widget_get_window(parent));

  gchar     *cmd    = g_strdup_printf(OSSO_PLUGIN_EXEC_LOADER_COMMAND
                                      " \"%s\" \"%s\" \"%lu\"",
                                      osso_application_name_get(osso),
                                      osso_application_version_get(osso),
                                      xid);

  gchar   *stdout = NULL;
  gchar   *stderr = NULL;
  GError  *error  = NULL;

  gint     status = 0;

  if(!g_spawn_command_line_sync(cmd, &stdout, &stderr, &status, &error))
  {
    if(error != NULL)
    {
      g_error("osso-plugin-exec-loader: %s", error->message);
      g_error_free(error);
    }

    g_free(cmd);
    g_free(stdout);
    g_free(stderr);

    return OSSO_ERROR;
  }

#ifdef DEBUG
  g_debug("osso-plugin-exec-loader "
          OSSO_PLUGIN_EXEC_LOADER_COMMAND " - STDOUT: %s", stdout);
  g_debug("osso-plugin-exec-loader "
          OSSO_PLUGIN_EXEC_LOADER_COMMAND " - STDERR: %s", stderr);
#endif

  g_free(cmd);
  g_free(stdout);
  g_free(stderr);

  return status;
}

osso_return_t save_state(osso_context_t *osso G_GNUC_UNUSED,
                         gpointer data G_GNUC_UNUSED)
{
  return OSSO_OK;
}

