import QtQuick 1.1
import org.maemo.fremantle 1.0
import org.maemo.extras 1.0
import PowEdit 1.0
import "components"

Page
{
    property string iconPath: ""
    property string iconName: ""
    property alias appNameString: entryName.text
    property string desktop: ""

    function reset()
    {
        iconName = ""
        iconPath = ""
        appNameString = ""
        desktop = ""
        iconMiniature.visible = false
    }

    Connections
    {
        target: cfgScanner
        onFinished:
        {
            console.log("cfgScanner finished, name is " + cfgScanner.name)
            iconName = cfgScanner.icon
            iconPath = cfgScanner.iconAbs
            iconMiniature.visible = true
            appNameString = cfgScanner.name
            entryName.readOnly = cfgScanner.nameReadOnly
            desktop = cfgScanner.desktop
        }
        onWarning:
        {
            //pageStack.pop()
            systemuicfgWarningDialog.infodetails = desc
            systemuicfgWarningDialog.open()
        }
        onError:
        {
            //pageStack.pop()
            systemuicfgErrorDialog.infodetails = desc
            systemuicfgErrorDialog.open()
        }
    }

    id: creationDetailsPage
    tools: creationDetailsPageTools
    Loader
    {
        id: selectAppSheetLoader
    }

    Flickable
    {
        id: flickDetails
        anchors.fill: parent
        contentHeight: detailsColumn.height + 10 // some kinda margin
        flickableDirection: Flickable.VerticalFlick
        clip: true

        Column
        {
            id: detailsColumn
            width: parent.width
            spacing: 20
            Header
            {
                id: caption
                headertext: "Specify the details"
            }
            TextField
            {
                id: entryName
                text: appNameString
                placeholderText: "Entry name"
                width: parent.width
            }

            Row
            {
                spacing:  10
                width: parent.width
                Label
                {
                    id: selectedIconLabel
                    text: "  Selected icon: "
                    anchors.verticalCenter: selectIconButton.verticalCenter
                }
                Button
                {
                    id: selectIconButton
                    width: parent.width - 20 - selectedIconLabel.width
                    text: ( iconPath == "" ) ? "No icon selected" : iconPath
                    onClicked:
                    {
                        selectIconDialog.open()
                    }
                }
            }
            Image
            {
                id: iconMiniature
                source: iconPath
                height: 80
                width: 80
                sourceSize.height: 80
                sourceSize.width: 80
                anchors.horizontalCenter: parent.horizontalCenter
                visible: false
            }
            Row
            {
                spacing:  10
                width: parent.width
                Label
                {
                    id: selectedAppLabel
                    text: "  Selected app: "
                    anchors.verticalCenter: selectAppButton.verticalCenter
                }
                Button
                {
                    id: selectAppButton
                    width: parent.width - 20 - selectedAppLabel.width
                    text: ( desktop == "" ) ? "No app selected" : desktop
                    onClicked:
                    {
                        selectDesktopDialog.open()
                    }
                }
            }
            Column
            {
                spacing: 10
                width: parent.width
                Label
                {
                    id: sliderLabel
                    text: "Item priority:"
                    anchors.horizontalCenter: parent.horizontalCenter
                }
                Slider
                {
                    id: prioritySlider
                    minimumValue: 0
                    maximumValue: 1000
                    value: 500
                    stepSize: 1
                    width: parent.width
                    valueIndicatorVisible: true
                    onValueChanged: creator.priority = value
                }
            }
            Button
            {
                id: gobutton
                width: parent.width - 20
                anchors.horizontalCenter: parent.horizontalCenter
                text: "Go!"
                onClicked:
                {
                    if ( (entryName.text == "") || (iconPath == "") || (desktop == "") )
                    {
                        fieldsEmpty.show()
                        return;
                    }

                    creator.appName = entryName.text; // in case it changed

                    if (creator.createEntry() == true)
                    {
                        creator.refreshSystemUI()
                        entryCreationOK.show()
                    }
                    else entryCreationFailed.show()
                    pageStack.pop()
                }
            }
        }
    }

    InfoBanner
    {
        id: entryCreationOK
        text: "Entry creation successful"
    }

    InfoBanner
    {
        id: entryCreationFailed
        text: "Entry creation failed"
    }

    InfoBanner
    {
        id: fieldsEmpty
        text: "Please fill all the fields!"
    }

    FileDialog
    {
        id: selectIconDialog
        folder: "/usr/share/icons/hicolor/"
        onAccepted:
        {
            creator.iconUrl = filePath
            iconPath = filePath
            iconMiniature.visible = true
        }
    }

    FileDialog
    {
        id: selectDesktopDialog
        folder: "/usr/share/applications/hildon"
        onAccepted:
        {
            if (filePath.substring(0, folder.length) == folder)
            {
                console.log("File " + filePath + " is a correct .desktop file")
                desktop = filePath
                creator.desktopName = filePath
            }
            else
            {
                console.log("File + " + filePath + " is not a correct .desktop file")
                selectDesktopDialog.open()
            }
        }
    }

    ToolBarLayout
    {
        id: creationDetailsPageTools
        anchors.centerIn: parent
        ToolIcon
        {
            platformIconId: "toolbar-back"
            onClicked:
            {
                pageStack.pop()
            }
        }

        ToolIcon
        {
            platformIconId: "toolbar-application"
            onClicked:
            {
                selectAppSheetLoader.source = "SelectAppSheet.qml"
                selectAppSheetLoader.item.open()
            }
        }
    }

    BusyIndicator
    {
        id: inddetails
        running: true
        visible: false
        anchors.centerIn: parent
        platformStyle: BusyIndicatorStyle
        {
            size: "large"
        }
    }
}
