import QtQuick 1.1
import org.maemo.fremantle 1.0
import PowEdit 1.0

PageStackWindow
{
    id: appWindow

    initialPage: selectActionTypePage

    SelectActionTypePage {id: selectActionTypePage}

    ToolBarLayout
    {
        id: commonTools
        visible: true
        ToolIcon
        {
            platformIconId: "toolbar-view-menu";
            anchors.right: parent.right
            onClicked: (myMenu.status == DialogStatus.Closed) ? myMenu.open() : myMenu.close()
        }
    }

    Menu
    {
        id: myMenu
        visualParent: pageStack
        MenuLayout
        {
            MenuItem { text: "Help" }
            MenuItem { text: "About" }
        }
    }

    PowerMenuEntryCreator { id: creator }
    DesktopFileScanner { id: scanner }
    SystemUICfgScanner
    {
        id: cfgScanner
    }

}
