/*
  Copyright (C) 2010, 2011  Sakari Hyoty

  This file is part of Pomodoro.

  Pomodoro is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Pomodoro is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Pomodoro.  If not, see <http://www.gnu.org/licenses/>.
  */

#include <QPushButton>

#include "taskdialog.h"
#include "ui_taskdialog.h"

TaskDialog::TaskDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::TaskDialog),
    modelIndex(0)
{
    qDebug("TaskDialog::TaskDialog");

    ui->setupUi(this);
    ui->buttonBox->button(QDialogButtonBox::Ok)->setEnabled(false);

    connect(ui->taskNameLineEdit, SIGNAL(textChanged(QString)), this, SLOT(taskNameChanged(QString)));
}

TaskDialog::~TaskDialog()
{
    qDebug("TaskDialog::~TaskDialog");

    delete ui;
}

void TaskDialog::showAdd()
{
    QDialog::show();
    setWindowTitle("Add task");
    ui->taskNameLineEdit->setFocus();
}

void TaskDialog::showEdit(const QModelIndex &index, QString taskName, int estimate)
{
    QDialog::show();
    setWindowTitle("Edit task");
    modelIndex = &index;
    ui->taskNameLineEdit->setText(taskName);
    ui->estimateSpinBox->setValue(estimate);
    ui->taskNameLineEdit->setFocus();
}

void TaskDialog::accept()
{
    qDebug("TaskDialog::accept");

    QDialog::accept();

    QString taskName = ui->taskNameLineEdit->text();
    int estimate = ui->estimateSpinBox->value();

    if (modelIndex) {
        emit taskUpdated(*modelIndex, taskName, estimate);
        modelIndex = 0;
    } else {
        emit newTask(taskName, estimate);
    }

    ui->taskNameLineEdit->setText("");
    ui->estimateSpinBox->setValue(0);
}

void TaskDialog::reject()
{
    qDebug("TaskDialog::reject");

    QDialog::reject();

    ui->taskNameLineEdit->setText("");
    ui->estimateSpinBox->setValue(0);
    modelIndex = 0;
}

void TaskDialog::changeEvent(QEvent *e)
{
    qDebug("TaskDialog::changeEvent");

    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void TaskDialog::taskNameChanged(QString newName)
{
    qDebug("TaskDialog::taskNameChanged");

    ui->buttonBox->button(QDialogButtonBox::Ok)->setEnabled(newName.size() > 0);
}
