/*
  Copyright (C) 2011  Sakari Hyoty

  This file is part of Pomodoro.

  Pomodoro is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Pomodoro is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Pomodoro.  If not, see <http://www.gnu.org/licenses/>.
  */

#ifndef SOUNDDIALOG_H
#define SOUNDDIALOG_H

#include <QDialog>

namespace Ui {
    class SoundDialog;
}

class SoundDialog : public QDialog
{
    Q_OBJECT

public:
    explicit SoundDialog(QWidget *parent = 0);
    ~SoundDialog();

public slots:
    void show(QString currentAudioFile);
    void browse();
    void reset();
    void accept(); // reimplemented from QDialog
    void reject(); // reimplemented from QDialog

signals:
    void alarmFileChanged(QString newFilePath);
    void alarmFileReset();

private:
    Ui::SoundDialog *ui;

};

#endif // SOUNDDIALOG_H
