/*
  Copyright (C) 2010, 2011  Sakari Hyoty

  This file is part of Pomodoro.

  Pomodoro is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Pomodoro is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Pomodoro.  If not, see <http://www.gnu.org/licenses/>.
  */

#ifndef POMODOROCONFIG_H
#define POMODOROCONFIG_H

#include <QDir>

const QString POMODORO_FILE_ALERT = "/opt/pomodoro/alarm.wav";
const QString POMODORO_FILE_MODEL = QDir::homePath() + '/' + ".pomodoro.data";
const QString POMODORO_VERSION = "0.3.0";
const QString POMODORO_HOMEPAGE = "http://www.iki.fi/shyoty/pomodoro/";
const QString POMODORO_FILE_SETTINGS = QDir::homePath() + '/' + ".pomodoro.settings";

const QString POMODORO_SETTINGS_KEY_ALARM = "alarm_file";
const int POMODORO_TIMER_LENGTH = 25 * 60; // seconds
const int POMODORO_TIMER_ALMOST_FINISHED = POMODORO_TIMER_LENGTH / 2; // seconds
const int POMODORO_MODEL_VERSION = 1;

const QString POMODORO_README_FILE = "/opt/pomodoro/README";

#endif // POMODOROCONFIG_H
