/*
  Copyright (C) 2010, 2011  Sakari Hyoty

  This file is part of Pomodoro.

  Pomodoro is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Pomodoro is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Pomodoro.  If not, see <http://www.gnu.org/licenses/>.
  */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QModelIndex>
#include <QString>
#include <phonon/MediaObject>

class PomodoroModel;
class PomodoroTimer;
class TaskDialog;
class SoundDialog;
class QItemSelection;

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

public slots:
    void addTask(QString taskName, int estimate);
    void editTask(const QModelIndex &index);
    void removeTask();
    void completeTask();
    void internalInterruption();
    void externalInterruption();

    void taskSelected(const QItemSelection & selected, const QItemSelection & deselected );
    void taskUpdated(const QModelIndex &index, QString taskName, int estimate);

    void pomodoroStarted(int lengthInSeconds);
    void pomodoroStopped(bool finished);
    void updateProgress(int secondsLeft);

    void showGuide();
    void showAbout();
    void removeCompletedTasks();
    void showChangeAlarmFile();

    void alarmFileChanged(QString newAudioFilePath);
    void alarmFileReset();

protected:
    void changeEvent(QEvent *e);

private:
    enum PomodoroUiState {
        IdleNoSelection,
        IdleTaskSelected,
        IdleCompletedTaskSelected,
        Started,
        AlmostFinished
    };

    void setUiState(PomodoroUiState state);

private:
    Ui::MainWindow *ui;
    PomodoroModel *pomodoroModel;
    QModelIndex selectedIndex;
    Phonon::MediaObject *alertMediaObject;
    PomodoroTimer *pomodoroTimer;
    TaskDialog *taskDialog;
    SoundDialog *soundDialog;
    QString alarmFile;
};

#endif // MAINWINDOW_H
