# Copyright (C) 2010  Sakari Hyoty
#
# This file is part of Pomodoro.
#
# Pomodoro is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Pomodoro is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Pomodoro.  If not, see <http://www.gnu.org/licenses/>.

TARGET = pomodoro
HEADERS = mainwindow.h \
    pomodoromodel.h \
    pomodorotimer.h \
    pomodoroconfig.h \
    src/taskdialog.h
SOURCES = main.cpp \
    mainwindow.cpp \
    pomodoromodel.cpp \
    pomodorotimer.cpp \
    src/taskdialog.cpp
FORMS = mainwindow.ui \
    src/taskdialog.ui
OTHER_FILES = data/pomodoro.desktop

# All generated files goes same directory
OBJECTS_DIR = build
MOC_DIR = build
UI_DIR = build
DESTDIR = build

TEMPLATE = app
VPATH = src ui
QT = core gui phonon
QMAKE_DISTCLEAN += pomodoro.pro.user

# Maemo 5 specific
contains(QT_CONFIG, hildon): {
    QT += dbus

    # Installs
    target.path = /usr/bin/
    desktop.path = /usr/share/applications/hildon
    desktop.files = data/pomodoro.desktop
    data.path = /opt/pomodoro
    data.files = data/alarm.wav README
    icon64.path = /usr/share/icons/hicolor/64x64/apps
    icon64.files = data/64x64/pomodoro.png
    INSTALLS = target desktop data icon64

    # Targets for debian source and binary package creation
    debian-src.commands = dpkg-buildpackage -S -r -us -uc -d
    debian-bin.commands = dpkg-buildpackage -b -r -uc -d
    debian-all.depends = debian-src debian-bin

    # Clean all but Makefile
    compiler_clean.commands = -$(DEL_FILE) $(TARGET)
    QMAKE_EXTRA_TARGETS += debian-all debian-src debian-bin compiler_clean
}
