//
// C++ Implementation: mycardspixmaplabel
//
// Description: 
//
//
// Author: FThauer FHammer <f.thauer@web.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "mychancelabel.h"
#include "gametableimpl.h"
#include "gametablestylereader.h"

using namespace std;

MyChanceLabel::MyChanceLabel(QWidget* parent)
 : QLabel(parent), myW(0), myStyle(0)
{

}

MyChanceLabel::~MyChanceLabel()
{
}

void MyChanceLabel::refreshChance(vector< vector<int> > chance)
{
	RFChance[0] = chance[0][9];
	SFChance[0] = chance[0][8];
	FOAKChance[0] = chance[0][7];
	FHChance[0] = chance[0][6];
	FLChance[0] = chance[0][5];
	STRChance[0] = chance[0][4];
	TOAKChance[0] = chance[0][3];
	TPChance[0] = chance[0][2];
	OPChance[0] = chance[0][1];
	HCChance[0] = chance[0][0];

	RFChance[1] = chance[1][9];
	SFChance[1] = chance[1][8];
	FOAKChance[1] = chance[1][7];
	FHChance[1] = chance[1][6];
	FLChance[1] = chance[1][5];
	STRChance[1] = chance[1][4];
	TOAKChance[1] = chance[1][3];
	TPChance[1] = chance[1][2];
	OPChance[1] = chance[1][1];
	HCChance[1] = chance[1][0];

	update();
}

void MyChanceLabel::paintEvent(QPaintEvent * /*event*/) {

	QPainter painter(this);


#ifdef _WIN32
	QString font1String = "font-family: \"Arial\";";
#else 
	#ifdef __APPLE__	
		QString font1String = "font-family: \"Lucida Grande\";";
	#else 
		QString font1String = "font-family: \"Nimbus Sans L\";";
	#endif
#endif
	QFont font;
	//font.setFamily(font1String);
	font.setPixelSize(15);
	painter.setFont(font);

	//Draw Texts
	QColor possible("#"+myStyle->getChanceLabelPossibleColor());
	QColor impossible("#"+myStyle->getChanceLabelImpossibleColor());

//*****//Make this easier to change...
	int yPos = 0;
	int yPad = 2;
	int ySize = 16;
	int width = 100;
	int percentWidth = 50;
	int xPosText = 2;
	int xPosPercent = 400;

	if(RFChance[1] == 0) { painter.setPen(impossible); }
	else { painter.setPen(possible); }
	painter.drawText(QRectF(QPointF(xPosText,yPos), QPointF(xPosText+width,yPos+ySize)),Qt::AlignRight,"Royal Flush");
	painter.drawText(QRectF(QPointF(xPosPercent,yPos), QPointF(xPosPercent+percentWidth,yPos+ySize)),Qt::AlignRight,QString("%1%").arg(RFChance[0]));
	yPos = yPos + ySize + yPad;
	if(SFChance[1] == 0) { painter.setPen(impossible); }
	else { painter.setPen(possible); }
	painter.drawText(QRectF(QPointF(xPosText,yPos), QPointF(xPosText+width,yPos+ySize)),Qt::AlignRight,"Straight Flush");
	painter.drawText(QRectF(QPointF(xPosPercent,yPos), QPointF(xPosPercent+percentWidth,yPos+ySize)),Qt::AlignRight,QString("%1%").arg(SFChance[0]));
	yPos = yPos + ySize + yPad;
	if(FOAKChance[1] == 0) { painter.setPen(impossible); }
	else { painter.setPen(possible); }
	painter.drawText(QRectF(QPointF(xPosText,yPos), QPointF(xPosText+width,yPos+ySize)),Qt::AlignRight,"Four of a Kind");
	painter.drawText(QRectF(QPointF(xPosPercent,yPos), QPointF(xPosPercent+percentWidth,yPos+ySize)),Qt::AlignRight,QString("%1%").arg(FOAKChance[0]));
	yPos = yPos + ySize + yPad;
	if(FHChance[1] == 0) { painter.setPen(impossible); }
	else { painter.setPen(possible); }
	painter.drawText(QRectF(QPointF(xPosText,yPos), QPointF(xPosText+width,yPos+ySize)),Qt::AlignRight,"Full House");
	painter.drawText(QRectF(QPointF(xPosPercent,yPos), QPointF(xPosPercent+percentWidth,yPos+ySize)),Qt::AlignRight,QString("%1%").arg(FHChance[0]));
	yPos = yPos + ySize + yPad;
	if(FLChance[1] == 0) { painter.setPen(impossible); }
	else { painter.setPen(possible); }	
	painter.drawText(QRectF(QPointF(xPosText,yPos), QPointF(xPosText+width,yPos+ySize)),Qt::AlignRight,"Flush");
	painter.drawText(QRectF(QPointF(xPosPercent,yPos), QPointF(xPosPercent+percentWidth,yPos+ySize)),Qt::AlignRight,QString("%1%").arg(FLChance[0]));
	yPos = yPos + ySize + yPad;
	if(STRChance[1] == 0) { painter.setPen(impossible); }
	else { painter.setPen(possible); }
	painter.drawText(QRectF(QPointF(xPosText,yPos), QPointF(xPosText+width,yPos+ySize)),Qt::AlignRight,"Straight");
	painter.drawText(QRectF(QPointF(xPosPercent,yPos), QPointF(xPosPercent+percentWidth,yPos+ySize)),Qt::AlignRight,QString("%1%").arg(STRChance[0]));
	yPos = yPos + ySize + yPad;
	if(TOAKChance[1] == 0) { painter.setPen(impossible); }
	else { painter.setPen(possible); }
	painter.drawText(QRectF(QPointF(xPosText,yPos), QPointF(xPosText+width,yPos+ySize)),Qt::AlignRight,"Three of a Kind");
	painter.drawText(QRectF(QPointF(xPosPercent,yPos), QPointF(xPosPercent+percentWidth,yPos+ySize)),Qt::AlignRight,QString("%1%").arg(TOAKChance[0]));
	yPos = yPos + ySize + yPad;
	if(TPChance[1] == 0) { painter.setPen(impossible); }
	else { painter.setPen(possible); }
	painter.drawText(QRectF(QPointF(xPosText,yPos), QPointF(xPosText+width,yPos+ySize)),Qt::AlignRight,"Two Pairs");
	painter.drawText(QRectF(QPointF(xPosPercent,yPos), QPointF(xPosPercent+percentWidth,yPos+ySize)),Qt::AlignRight,QString("%1%").arg(TPChance[0]));
	yPos = yPos + ySize + yPad;
	if(OPChance[1] == 0) { painter.setPen(impossible); }
	else { painter.setPen(possible); }
	painter.drawText(QRectF(QPointF(xPosText,yPos), QPointF(xPosText+width,yPos+ySize)),Qt::AlignRight,"One Pair");
	painter.drawText(QRectF(QPointF(xPosPercent,yPos), QPointF(xPosPercent+percentWidth,yPos+ySize)),Qt::AlignRight,QString("%1%").arg(OPChance[0]));
	yPos = yPos + ySize + yPad;
	if(HCChance[1] == 0) { painter.setPen(impossible); }
	else { painter.setPen(possible); }
	painter.drawText(QRectF(QPointF(xPosText,yPos), QPointF(xPosText+width,yPos+ySize)),Qt::AlignRight,"Highest Card");
	painter.drawText(QRectF(QPointF(xPosPercent,yPos), QPointF(xPosPercent+percentWidth,yPos+ySize)),Qt::AlignRight,QString("%1%").arg(HCChance[0]));

	//Draw gfx
	painter.setPen(QColor(0,0,0));
	
	int xMargin = 5;
	yPos = 2;
	int barHeight = 12;
	yPad = 6;

	QLinearGradient linearGrad(QPointF(xPosText+width+xMargin,yPos), QPointF(300,yPos+barHeight));
	linearGrad.setColorAt(0, Qt::blue);
	linearGrad.setColorAt(0.5, Qt::yellow);
	linearGrad.setColorAt(1, Qt::red);
	painter.setBrush(linearGrad);



	if(RFChance[1] != 0) painter.drawRect(xPosText+width+5,yPos,(300*RFChance[0])/100,14);	yPos = yPos + barHeight + yPad;
	if(SFChance[1] != 0) painter.drawRect(xPosText+width+5,yPos,(300*SFChance[0])/100,14);	yPos = yPos + barHeight + yPad;
	if(FOAKChance[1] != 0) painter.drawRect(xPosText+width+5,yPos,(300*FOAKChance[0])/100,14);	yPos = yPos + barHeight + yPad;
	if(FHChance[1] != 0) painter.drawRect(xPosText+width+5,yPos,(300*FHChance[0])/100,14);	yPos = yPos + barHeight + yPad;
	if(FLChance[1] != 0) painter.drawRect(xPosText+width+5,yPos,(300*FLChance[0])/100,14);	yPos = yPos + barHeight + yPad;
	if(STRChance[1] != 0) painter.drawRect(xPosText+width+5,yPos,(300*STRChance[0])/100,14);	yPos = yPos + barHeight + yPad;
	if(TOAKChance[1] != 0) painter.drawRect(xPosText+width+5,yPos,(300*TOAKChance[0])/100,14);	yPos = yPos + barHeight + yPad;
	if(TPChance[1] != 0) painter.drawRect(xPosText+width+5,yPos,(300*TPChance[0])/100,14);	yPos = yPos + barHeight + yPad;
	if(OPChance[1] != 0) painter.drawRect(xPosText+width+5,yPos,(300*OPChance[0])/100,14);	yPos = yPos + barHeight + yPad;
	if(HCChance[1] != 0) painter.drawRect(xPosText+width+5,yPos,(300*HCChance[0])/100,14);
}


void MyChanceLabel::resetChance()
{
	RFChance[0] = 0;
	SFChance[0] = 0;
	FOAKChance[0] = 0;
	FHChance[0] = 0;
	FLChance[0] = 0;
	STRChance[0] = 0;
	TOAKChance[0] = 0;
	TPChance[0] = 0;
	OPChance[0] = 0;
	HCChance[0] = 0;

	RFChance[1] = 0;
	SFChance[1] = 0;
	FOAKChance[1] = 0;
	FHChance[1] = 0;
	FLChance[1] = 0;
	STRChance[1] = 0;
	TOAKChance[1] = 0;
	TPChance[1] = 0;
	OPChance[1] = 0;
	HCChance[1] = 0;

	update();
}
