#ifndef HELPERS_H
#define HELPERS_H

#include <gtk/gtk.h>

// messagetype:
// GTK_MESSAGE_INFO: Informational message
// GTK_MESSAGE_WARNING: Nonfatal warning message
// GTK_MESSAGE_QUESTION: Question requiring a choice
// GTK_MESSAGE_ERROR: Fatal error message
// GTK_MESSAGE_OTHER: None of the above, doesn't get an icon

int GetMultiple2Mask(int input);

int FileExist(char *filename);

int ExtensionCheck(const char *filename, const char *ext);

void MessageDialog(GtkWindow *parentwindow, const char *caption, const char *title, int messagetype);

int YesNoDialog(GtkWindow *parentwindow, const char *caption, const char *title, int messagetype);

int OpenFileDialog(GtkWindow *parentwindow, const char *title, char *fileout);

int SaveFileDialog(GtkWindow *parentwindow, const char *title, char *fileout, const char *filein);

int PickColorFormatDialog(GtkWindow *parentwindow);

int EnterNumberDialog(GtkWindow *parentwindow, const char *title, const char *caption, int *numberout, int numberin, int hexnum);

#endif
