#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "helpers.h"

int GetMultiple2Mask(int input)
{
	if (input) input--;
	input |= (input >> 1);
	input |= (input >> 2);
	input |= (input >> 4);
	input |= (input >> 8);
	input |= (input >> 16);
	return input;
}

int FileExist(char *filename)
{
	FILE *fi;
	if (!filename) return 0;
	fi = fopen(filename, "rb");
	if (fi == NULL) return 0;
	fclose(fi);
	return 1;
}

int ExtensionCheck(const char *filename, const char *ext)
{
	int i;
	for (i = strlen(filename)-1; i >= 0; i--) {
		if (filename[i] == '.') {
			if (strcasecmp(&filename[i], ext) == 0) {
				return 1;
			}
		}
	}
	return 0;
}

void MessageDialog(GtkWindow *parentwindow, const char *caption, const char *title, int messagetype)
{
	GtkDialog *dialog;

	dialog = GTK_DIALOG(gtk_message_dialog_new(NULL, GTK_DIALOG_DESTROY_WITH_PARENT, messagetype, GTK_BUTTONS_OK, "%s", caption));
	gtk_window_set_title(GTK_WINDOW(dialog), title);
	gtk_window_present(GTK_WINDOW(dialog));
	gtk_dialog_run(dialog);
	gtk_window_present(parentwindow);
	gtk_widget_destroy(GTK_WIDGET(dialog));
}

int YesNoDialog(GtkWindow *parentwindow, const char *caption, const char *title, int messagetype)
{
	GtkDialog *dialog;
	GtkResponseType response;

	dialog = GTK_DIALOG(gtk_message_dialog_new(NULL, GTK_DIALOG_DESTROY_WITH_PARENT, messagetype, GTK_BUTTONS_YES_NO, "%s", caption));
	gtk_window_set_title(GTK_WINDOW(dialog), title);
	gtk_window_present(GTK_WINDOW(dialog));
	response = gtk_dialog_run(dialog);
	gtk_window_present(parentwindow);
	gtk_widget_destroy(GTK_WIDGET(dialog));

	return (response == GTK_RESPONSE_YES);
}

int OpenFileDialog(GtkWindow *parentwindow, const char *title, char *fileout)
{
	GtkDialog *dialog;
	GtkResponseType response;
	char *filename;

	dialog = GTK_DIALOG(gtk_file_chooser_dialog_new(title, GTK_WINDOW(parentwindow), GTK_FILE_CHOOSER_ACTION_OPEN,
		GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
		GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
		NULL));

	gtk_window_present(GTK_WINDOW(dialog));
	response = gtk_dialog_run(dialog);
	if (response == GTK_RESPONSE_ACCEPT) {
		filename = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(dialog));
		if (fileout) strcpy(fileout, filename);
		g_free(filename);
	}
	gtk_widget_destroy(GTK_WIDGET(dialog));
	gtk_window_present(parentwindow);

	return (response == GTK_RESPONSE_ACCEPT);
}

int SaveFileDialog(GtkWindow *parentwindow, const char *title, char *fileout, const char *filein)
{
	GtkDialog *dialog;
	GtkResponseType response;
	char *filename;

	dialog = GTK_DIALOG(gtk_file_chooser_dialog_new(title, GTK_WINDOW(parentwindow), GTK_FILE_CHOOSER_ACTION_SAVE,
		GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT,
		GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
		NULL));
	gtk_file_chooser_set_do_overwrite_confirmation(GTK_FILE_CHOOSER(dialog), TRUE);
	gtk_file_chooser_set_current_name(GTK_FILE_CHOOSER(dialog), filein);

	gtk_window_present(GTK_WINDOW(dialog));
	response = gtk_dialog_run(dialog);
	if (response == GTK_RESPONSE_ACCEPT) {
		filename = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(dialog));
		if (fileout) strcpy(fileout, filename);
		g_free(filename);
	}
	gtk_widget_destroy(GTK_WIDGET(dialog));
	gtk_window_present(parentwindow);

	return (response == GTK_RESPONSE_ACCEPT);
}

int PickColorFormatDialog(GtkWindow *parentwindow)
{
	GtkDialog *dialog;
	GtkResponseType response;
	GtkBox *vbox;
	GtkLabel *label1;
	GtkComboBox *combobox;
	GtkLabel *label2;
	int pickedcolorformat = 0;

	dialog = GTK_DIALOG(gtk_dialog_new_with_buttons("Color Format", parentwindow,
		GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
		GTK_STOCK_OK, GTK_RESPONSE_OK,
		NULL));

	vbox = GTK_BOX(gtk_vbox_new(FALSE, 8));
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 8);
	gtk_box_pack_start(GTK_BOX(dialog->vbox), GTK_WIDGET(vbox), FALSE, FALSE, 0);

	label1 = GTK_LABEL(gtk_label_new("Select Color Format:"));
	gtk_box_pack_start(vbox, GTK_WIDGET(label1), FALSE, TRUE, 8);

	combobox = GTK_COMBO_BOX(gtk_combo_box_new_text());
	gtk_combo_box_append_text(combobox, "8x8 Attributes");
	gtk_combo_box_append_text(combobox, "4x4 Attributes");
	gtk_combo_box_set_active(combobox, 0);
	gtk_box_pack_start(vbox, GTK_WIDGET(combobox), FALSE, TRUE, 8);

	label2 = GTK_LABEL(gtk_label_new("8x8 will use 1/4 of memory and storage\n4x4 will avoid attribute clash better\nOnce selected it cannot be changed!"));
	gtk_box_pack_start(vbox, GTK_WIDGET(label2), FALSE, TRUE, 8);

	gtk_window_present(GTK_WINDOW(dialog));
	gtk_widget_show_all(GTK_WIDGET(vbox));
	response = gtk_dialog_run(dialog);
	pickedcolorformat = gtk_combo_box_get_active(combobox);
	gtk_widget_destroy(GTK_WIDGET(dialog));
	gtk_window_present(parentwindow);

	return pickedcolorformat;
}

int EnterNumberDialog(GtkWindow *parentwindow, const char *title, const char *caption, int *numberout, int numberin, int hexnum)
{
	GtkDialog *dialog;
	GtkResponseType response;
	GtkBox *vbox;
	GtkLabel *label1;
	GtkEntry *entry;
	GtkLabel *label2;
	char number[64];
	int result = 0;

	if (hexnum) {
		if (numberin < 0) sprintf(number, "-0x%04X", numberin);
		else sprintf(number, "0x%04X", numberin);
	} else {
		sprintf(number, "%i", numberin);
	}

	dialog = GTK_DIALOG(gtk_dialog_new_with_buttons(title, GTK_WINDOW(parentwindow),
		GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
		GTK_STOCK_OK, GTK_RESPONSE_OK,
		GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
		NULL));

	vbox = GTK_BOX(gtk_vbox_new(FALSE, 8));
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 8);
	gtk_box_pack_start(GTK_BOX(dialog->vbox), GTK_WIDGET(vbox), FALSE, FALSE, 0);

	label1 = GTK_LABEL(gtk_label_new(caption));
	gtk_box_pack_start(vbox, GTK_WIDGET(label1), FALSE, TRUE, 8);

	entry = GTK_ENTRY(gtk_entry_new());
	gtk_entry_set_text(GTK_ENTRY(entry), number);
	gtk_box_pack_start(vbox, GTK_WIDGET(entry), FALSE, TRUE, 8);

	label2 = GTK_LABEL(gtk_label_new("Type \"0x\" for hexadecimal numbers"));
	gtk_box_pack_start(vbox, GTK_WIDGET(label2), FALSE, TRUE, 8);

	gtk_window_present(GTK_WINDOW(dialog));
	gtk_widget_show_all(GTK_WIDGET(vbox));
	response = gtk_dialog_run(dialog);

	if (response == GTK_RESPONSE_OK) {
		if (sscanf(gtk_entry_get_text(GTK_ENTRY(entry)), "%i", numberout) == 1) result = 1;
		else result = -1;
	}
	
	gtk_widget_destroy(GTK_WIDGET(dialog));
	gtk_window_present(parentwindow);

	return result;
}
