/*
  PokeMini - Pokmon-Mini Emulator
  Copyright (C) 2009  JustBurn

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef PMCOMMON_H
#define PMCOMMON_H

#ifndef inline
#define inline __inline
#endif

// Return a number between min and max
static inline int BetweenNum(int num, int min, int max)
{
	return (num < min) ? min : (num > max) ? max : num;
}

// Return true if the string is valid and non-empty
int StringIsSet(char *str);

// Get multiple of 2
int GetMultiple2(int input);

// Get multiple of 2 (Mask)
int GetMultiple2Mask(int input);

// Check if file exist
int FileExist(const char *filename);

// Get filename
char *GetFilename(const char *filename);

// Get extension
char *GetExtension(const char *filename);

// Does have path?
int DoesHavePath(char *filename);

// Extract path
char *ExtractPath(char *filename, int slash);

// Extract extension
char *ExtractExtension(char *filename);

// Check if filename has certain extension
int ExtensionCheck(const char *filename, const char *ext);

// Trim string
char *TrimStr(char *s);

// Remove comments
void RemoveComments(char *s);

// Up to token...
char *UpToToken(char *out, const char *in, char *tokens, char *tokenfound);

// Remove characters
void RemoveChars(char *out, const char *in, char *chs);

// Convert string to boolean
int Str2Bool(char *s);

// Convert boolean to string
const char *Bool2Str(int i);

// Convert boolean to string with an affirmative result
const char *Bool2StrAf(int i);

// Clear control characters
void ClearCtrlChars(char *s, int len);

#endif
