/*
  PokeMini - Pokmon-Mini Emulator
  Copyright (C) 2009  JustBurn

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "PMCommon.h"

// Return true if the string is valid and non-empty
int StringIsSet(char *str)
{
	if (!str) return 0;
	if (strlen(str) == 0) return 0;
	return 1;
}

// Get multiple of 2
int GetMultiple2(int input)
{
	if (!input) return 0;
	input--;
	input |= (input >> 1);
	input |= (input >> 2);
	input |= (input >> 4);
	input |= (input >> 8);
	input |= (input >> 16);
	return input+1;
}

// Get multiple of 2 (Mask)
int GetMultiple2Mask(int input)
{
	if (input) input--;
	input |= (input >> 1);
	input |= (input >> 2);
	input |= (input >> 4);
	input |= (input >> 8);
	input |= (input >> 16);
	return input;
}

// Check if file exist
int FileExist(const char *filename)
{
	FILE *fi;

	// Test open file
	fi = fopen(filename, "rb");
	if (fi == NULL) return 0;
	fclose(fi);

	return 1;
}

// Get filename
char *GetFilename(const char *filename)
{
	int i;
	for (i = strlen(filename)-1; i >= 0; i--) {
		if ((filename[i] == '/') || (filename[i] == '\\')) {
			return (char *)&filename[i+1];
		}
	}
	return (char *)filename;
}

// Get extension
char *GetExtension(const char *filename)
{
	int i;
	for (i = strlen(filename)-1; i >= 0; i--) {
		if (filename[i] == '.') {
			return (char *)&filename[i];
		}
		if ((filename[i] == '/') || (filename[i] == '\\')) {
			return (char *)&filename[strlen(filename)-1];
		}
	}
	return (char *)filename;
}

// Does have path?
int DoesHavePath(char *filename)
{
	int i;
	for (i = strlen(filename)-1; i >= 0; i--) {
		if ((filename[i] == '/') || (filename[i] == '\\')) {
			return 1;
		}
	}
	return 0;
}

// Extract path
char *ExtractPath(char *filename, int slash)
{
	int i;
	for (i = strlen(filename)-1; i >= 0; i--) {
		if ((filename[i] == '/') || (filename[i] == '\\')) {
			if (slash) filename[i+1] = 0;
			else filename[i] = 0;
			return filename;
		}
	}
	if (slash && !strlen(filename)) {
		filename[0] = '.';
		filename[1] = '/';
		filename[2] = 0;
	}
	return filename;
}

// Extract extension
char *ExtractExtension(char *filename)
{
	int i;
	for (i = strlen(filename)-1; i >= 0; i--) {
		if (filename[i] == '.') {
			filename[i] = 0;
			return filename;
		}
		if ((filename[i] == '/') || (filename[i] == '\\')) {
			return filename;
		}
	}
	return filename;
}

// Check if filename has certain extension
int ExtensionCheck(const char *filename, const char *ext)
{
	int i;
	for (i = strlen(filename)-1; i >= 0; i--) {
		if (filename[i] == '.') {
			if (strcasecmp(&filename[i], ext) == 0) {
				return 1;
			}
		}
		if ((filename[i] == '/') || (filename[i] == '\\')) {
			return 0;
		}
	}
	return 0;
}

// Trim string
char *TrimStr(char *s)
{
	int siz = strlen(s);
	char *ptr = s + siz - 1;
	if (!siz) return s;
	while ((ptr >= s) && (isspace((int)*ptr) || (*ptr == '\n') || (*ptr == '\r'))) --ptr;
	ptr[1] = '\0';
	while ((*s != 0) && (isspace((int)*s) || (*s == '\n') || (*s == '\r'))) s++;
	return s;
}

// Remove comments
void RemoveComments(char *s)
{
	while ((*s != 0) && (*s != ';') && (*s != '#')) s++;
	*s = 0;
}

// Up to token...
char *UpToToken(char *out, const char *in, char *tokens, char *tokenfound)
{
	char ch, *ltokens, lch;
	if (out) *out = 0;
	if (in) {
		while ((ch = *in++) != 0) {
			ltokens = tokens;
			while ((lch = *ltokens++) != 0) {
				if (ch == lch) {
					if (tokenfound) *tokenfound = lch;
					return (char *)in;
				}
			}
			if (out) {
				*out++ = ch;
				*out = 0;
			}
		}
	}
	if (tokenfound) *tokenfound = 0;
	return (char *)in;
}

// Remove characters
void RemoveChars(char *out, const char *in, char *chs)
{
	char ch, *lchs, lch;
	if (in) {
		while ((ch = *in++) != 0) {
			lchs = chs;
			while ((lch = *lchs++) != 0) {
				if (ch == lch) break;
			}
			if ((!lch) && (out)) {
				*out++ = ch;
			}
		}
	}
	if (out) *out = 0;
}

// Convert string to boolean
int Str2Bool(char *s)
{
	if (!strcasecmp(s, "1")) return 1;
	else if (!strcasecmp(s, "y")) return 1;
	else if (!strcasecmp(s, "yes")) return 1;
	else if (!strcasecmp(s, "t")) return 1;
	else if (!strcasecmp(s, "true")) return 1;
	else if (!strcasecmp(s, "on")) return 1;
	return 0;
}

// Convert boolean to string
const char *Bool2Str(int i)
{
	return (i ? "true" : "false");
}

// Convert boolean to string with an affirmative result
const char *Bool2StrAf(int i)
{
	return (i ? "yes" : "no");
}

// Clear control characters
void ClearCtrlChars(char *s, int len)
{
	if (!len) return;
	while (len--) {
		if (*s < 32) *s = '.';
		s++;
	}
}
