/*
  PokeMini - Pokémon-Mini Emulator
  Copyright (C) 2009  JustBurn

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef POKEMINI_KEYBOARD
#define POKEMINI_KEYBOARD

#include "UI.h"

enum {
	PMKEYB_NONE		= 0,
	PMKEYB_RETURN		= 1,
	PMKEYB_BACKSPACE	= 2,

	PMKEYB_LSHIFT		= 3,
	PMKEYB_LCTRL		= 4,

	PMKEYB_UP		= 5,
	PMKEYB_DOWN		= 6,
	PMKEYB_RIGHT		= 7,
	PMKEYB_LEFT		= 8,

	PMKEYB_SPACE		= 9,
	PMKEYB_EXCLAIM		= 10,
	PMKEYB_QUOTEDBL		= 11,
	PMKEYB_HASH		= 12,
	PMKEYB_DOLLAR		= 13,
	PMKEYB_PERCENT		= 14,
	PMKEYB_AMPERSAND	= 15,
	PMKEYB_QUOTE		= 16,
	PMKEYB_LEFTPAREN	= 17,
	PMKEYB_RIGHTPAREN	= 18,
	PMKEYB_ASTERISK		= 19,
	PMKEYB_PLUS		= 20,
	PMKEYB_COMMA		= 21,
	PMKEYB_MINUS		= 22,
	PMKEYB_PERIOD		= 23,
	PMKEYB_SLASH		= 24,

	PMKEYB_COLON		= 25,
	PMKEYB_SEMICOLON	= 26,
	PMKEYB_LESS		= 27,
	PMKEYB_EQUALS		= 28,
	PMKEYB_GREATER		= 29,
	PMKEYB_QUESTION		= 30,
	PMKEYB_AT		= 31,

	PMKEYB_A		= 32,
	PMKEYB_B		= 33,
	PMKEYB_C		= 34,
	PMKEYB_D		= 35,
	PMKEYB_E		= 36,
	PMKEYB_F		= 37,
	PMKEYB_G		= 38,
	PMKEYB_H		= 39,
	PMKEYB_I		= 40,
	PMKEYB_J		= 41,
	PMKEYB_K		= 42,
	PMKEYB_L		= 43,
	PMKEYB_M		= 44,
	PMKEYB_N		= 45,
	PMKEYB_O		= 46,
	PMKEYB_P		= 47,
	PMKEYB_Q		= 48,
	PMKEYB_R		= 49,
	PMKEYB_S		= 50,
	PMKEYB_T		= 51,
	PMKEYB_U		= 52,
	PMKEYB_V		= 53,
	PMKEYB_W		= 54,
	PMKEYB_X		= 55,
	PMKEYB_Y		= 56,
	PMKEYB_Z		= 57,

	PMKEYB_LEFTBRACK	= 58,
	PMKEYB_BACKSLASH	= 59,
	PMKEYB_RIGHTBRACK	= 60,
	PMKEYB_CARET		= 61,
	PMKEYB_UNDERSCORE	= 62,

	PMKEYB_WORLD_64 = 63, // à
	PMKEYB_WORLD_68 = 64, // ä
	PMKEYB_WORLD_69 = 65, // å
	PMKEYB_WORLD_70 = 66, // æ
	PMKEYB_WORLD_71 = 67, // ç
	PMKEYB_WORLD_72 = 68, // è
	PMKEYB_WORLD_73 = 69, // é
	PMKEYB_WORLD_81 = 70, // ñ
	PMKEYB_WORLD_82 = 71, // ò
	PMKEYB_WORLD_86 = 72, // ö
	PMKEYB_WORLD_88 = 73, // ø
	PMKEYB_WORLD_89 = 74, // ů
	PMKEYB_WORLD_92 = 75, // ü

	PMKEYB_EOL		= 76
};

// Keyboard map string
char *KeyboardMapStr[PMKEYB_EOL];

// Keyboard remapper
typedef int TKeyboardRemap[PMKEYB_EOL];
void KeyboardRemap(TKeyboardRemap *keymap);

// Keyboard menu items
extern TUIMenu_Item UIItems_Keyboard[];

// Enter into the keyboard menu
void KeyboardEnterMenu(void);

// Process keyboard press
int KeyboardPressEvent(int keysym);

// Process keyboard press
int KeyboardReleaseEvent(int keysym);

#endif
