// -*- coding: utf-8; -*-
// (c) Copyright 2010, Nick Slobodsky (Николай Слободской)
// This file is part of PlansPlant.
//
// PlansPlant is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// PlansPlant is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with PlansPlant.  If not, see <http://www.gnu.org/licenses/>.
//
#include "plansplant/utility.hpp"
namespace PlansPlant
{
  QIcon load_icon( const QString& IconName, const QString& Prefix )
  {
#if QT_VERSION < 0x040600
    return QIcon( ":/images/" + IconName + ".svg" );
#else
    return QIcon::fromTheme( Prefix + IconName, QIcon( ":/images/" + IconName + ".svg" ) );
#endif    
  } // load_icon( const QString&, const QString& )
} // PlansPlant
