// -*- coding: utf-8; -*-
// (c) Copyright 2010, Nick Slobodsky (Николай Слободской)
// This file is part of PlansPlant.
//
// PlansPlant is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// PlansPlant is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with PlansPlant.  If not, see <http://www.gnu.org/licenses/>.
//
#include "plansplant/tasks_changes.hpp"
#include <timeshop.hpp>
#include <QDebug>
namespace PlansPlant
{
  void Task::Change::inform( Watcher& Dest, Task& Object ) const
  {
    Dest.task_changed( Object, Field );
  } // inform( Watcher&, Task& ) const
  void Task::Change::write( QXmlStreamWriter& Stream ) const
  {
    Stream.writeStartElement( "change" );
    Stream.writeAttribute( "field", QString::number( field() ) );
    write_fields( Stream );
    Stream.writeEndElement();
  } // write( QXmlStreamWriter& ) const
  void Task::Change::write_fields( QXmlStreamWriter& /*Stream*/ ) const { /* Nothing */ }
    
  void Task::Changes::StringChange::load_fields( QXmlStreamReader& Stream )
  {
    while( Timeshop::Persistent::Loader::next_subelement( Stream ) )
      if( Stream.name() == "value" )
	Value = Stream.readElementText();
      else
	Timeshop::Persistent::Loader::skip( Stream );
  } // load_fields( QXmlStreamReader& )
  void Task::Changes::DateTimeChange::load_fields( QXmlStreamReader& Stream )
  {
    while( Timeshop::Persistent::Loader::next_subelement( Stream ) )
      if( Stream.name() == "value" )
	Value = read_time( Stream );
      else
	Timeshop::Persistent::Loader::skip( Stream );
  } // load_fields( QXmlStreamReader& )

  Task::Changes::Name* Task::Changes::Name::load( QXmlStreamReader& Stream, TasksFile& /*Tasks*/ )
  {
    Name* Result = new Name;
    Result->load_fields( Stream );
    return Result;
  } // load( QXmlStreamReader&, TasksFile& )
  Task::Changes::Description* Task::Changes::Description::load( QXmlStreamReader& Stream, TasksFile& /*Tasks*/ )
  {
    Description* Result = new Description;
    Result->load_fields( Stream );
    return Result;
  } // load( QXmlStreamReader&, TasksFile& )
  Task::Changes::Priority* Task::Changes::Priority::load( QXmlStreamReader& Stream, TasksFile& /*Tasks*/ )
  {
    Priority* Result = new Priority;
    while( Timeshop::Persistent::Loader::next_subelement( Stream ) )
      if( Stream.name() == "value" )
	Result->Value = Stream.readElementText().toInt();
      else
	Timeshop::Persistent::Loader::skip( Stream );
    return Result;
  } // load( QXmlStreamReader&, TasksFile& )
  Task::Changes::Completed* Task::Changes::Completed::load( QXmlStreamReader& Stream, TasksFile& /*Tasks*/ )
  {
    Completed* Result = new Completed;
    while( Timeshop::Persistent::Loader::next_subelement( Stream ) )
      if( Stream.name() == "value" )
	Result->Value = Stream.readElementText().toDouble();
      else
	Timeshop::Persistent::Loader::skip( Stream );
    return Result;
  } // load( QXmlStreamReader&, TasksFile& )
  Task::Changes::PlanStart* Task::Changes::PlanStart::load( QXmlStreamReader& Stream, TasksFile& /*Tasks*/ )
  {
    PlanStart* Result = new PlanStart;
    Result->load_fields( Stream );
    return Result;
  } // load( QXmlStreamReader&, TasksFile& )
  Task::Changes::PlanFinish* Task::Changes::PlanFinish::load( QXmlStreamReader& Stream, TasksFile& /*Tasks*/ )
  {
    PlanFinish* Result = new PlanFinish;
    Result->load_fields( Stream );
    return Result;
  } // load( QXmlStreamReader&, TasksFile& )
  Task::Changes::Estimation* Task::Changes::Estimation::load( QXmlStreamReader& Stream, TasksFile& /*Tasks*/ )
  {
    Estimation* Result = new Estimation;
    while( Timeshop::Persistent::Loader::next_subelement( Stream ) )
      if( Stream.name() == "value" )
	Result->Value = Stream.readElementText().toInt();
      else
	Timeshop::Persistent::Loader::skip( Stream );
    return Result;
  } // load( QXmlStreamReader&, TasksFile& )
  Task::Changes::EstimationUnits* Task::Changes::EstimationUnits::load( QXmlStreamReader& Stream, TasksFile& /*Tasks*/ )
  {
    EstimationUnits* Result = new EstimationUnits;
    while( Timeshop::Persistent::Loader::next_subelement( Stream ) )
      if( Stream.name() == "value" )
	Result->Value = TimeUnits( Stream.readElementText().toInt() );
      else
	Timeshop::Persistent::Loader::skip( Stream );
    return Result;
  } // load( QXmlStreamReader&, TasksFile& )
  Task::Changes::Comment* Task::Changes::Comment::load( QXmlStreamReader& Stream, TasksFile& /*Tasks*/ )
  {
    Comment* Result = new Comment;
    Result->load_fields( Stream );
    return Result;
  } // load( QXmlStreamReader&, TasksFile& )

  Task::Changes::SuperTask* Task::Changes::SuperTask::load( QXmlStreamReader& Stream, TasksFile& Tasks )
  {
    SuperTask* Result = new SuperTask;
    while( Timeshop::Persistent::Loader::next_subelement( Stream ) )
      if( Stream.name() == "value" )
      {
	QString IDStr = Stream.readElementText();
	if( IDStr != "root" )
	  Result->Value = Tasks.find_task( IDStr );
      }
      else
	Timeshop::Persistent::Loader::skip( Stream );
    return Result;
  } // load( QXmlStreamReader& Stream, TasksFile& )
  void Task::Changes::SuperTask::apply( Task& Object, TasksFile& File ) const
  {
    bool UpdateRoots = !Value != !Object.supertask(); 
    Object.supertask( Value );
    if( UpdateRoots ) File.update_root_status( Object );
  } // apply( Task&, TasksFile& ) const
  void Task::Changes::SuperTask::write_fields( QXmlStreamWriter& Stream ) const
  {
    if( Value && Value->id().valid() ) Stream.writeTextElement( "value", Value->id().str() );
    else Stream.writeTextElement( "value", "root" );
  } // write_fields( QXmlStreamWriter& ) const

  // TimeListChange
  void Task::Changes::Times::Operation::write( QXmlStreamWriter& Stream ) const
  {
    Stream.writeStartElement( "operation" );
    Stream.writeAttribute( "type", QString::number( type() ) );
    write_fields( Stream );
    Stream.writeEndElement();
  } // write( QXmlStreamWriter& ) const
  void Task::Changes::Times::Operation::write_fields( QXmlStreamWriter& Stream ) const
  {
    Stream.writeTextElement( "index", QString::number( Index ) );
  } // write_fields( QXmlStreamWriter& ) const
  void Task::Changes::Times::Operation::load_fields( QXmlStreamReader& Stream )
  {
    while( Timeshop::Persistent::Loader::next_subelement( Stream ) )
      load_field( Stream.name(), Stream );
  } // load_fields( QXmlStreamReader& )
  void Task::Changes::Times::Operation::load_field( const QStringRef& Tag, QXmlStreamReader& Stream )
  {
    if( Tag == "index" )
      Index = Stream.readElementText().toInt();
    else
      Timeshop::Persistent::Loader::skip( Stream );
  } // load_field( const QStringRef&, QXmlStreamReader&, TasksFile& )
  void Task::Changes::Times::Operations::Insert::apply( Task& Object ) const
  {
    Object.insert_time( Slice, Index );
  } // apply( Task& ) const
  void Task::Changes::Times::Operations::Insert::load_field( const QStringRef& Tag, QXmlStreamReader& Stream )
  {
    if( Tag == "time_slice" )
      Slice.load( Stream );
    else
      Operation::load_field( Tag, Stream );
  } // load_field( const QStringRef&, QXmlStreamReader& )
  void Task::Changes::Times::Operations::Insert::write_fields( QXmlStreamWriter& Stream ) const
  {
    Operation::write_fields( Stream );
    Slice.write( Stream );
  } // write_fields( QXmlStreamWriter& ) const
  void Task::Changes::Times::Operations::Remove::apply( Task& Object ) const { Object.remove_time( Index ); } // apply( Task& ) const
  void Task::Changes::Times::Operations::Move::apply( Task& Object ) const { Object.move_time( Index, NewIndex ); } // apply( Task& ) const
  void Task::Changes::Times::Operations::Move::load_field( const QStringRef& Tag, QXmlStreamReader& Stream )
  {
    if( Tag == "new_index" )
      NewIndex = Stream.readElementText().toInt();
    else
      Operation::load_field( Tag, Stream );
  } // load_field( const QStringRef&, QXmlStreamReader& )
  void Task::Changes::Times::Operations::Move::write_fields( QXmlStreamWriter& Stream ) const
  {
    Operation::write_fields( Stream );
    Stream.writeTextElement( "new_index", QString::number( NewIndex ) );
  } // write_fields( QXmlStreamWriter& ) const
  void Task::Changes::Times::Operations::Change::apply( Task& Object ) const
  {
    int I = Index < 0 ? Object.times().size()-1 : Index;
    switch( Field )
    {
    case Start:	 Object.time( I ).start( NewTime );  break;
    case Finish: Object.time( I ).finish( NewTime ); break;
    default: break;
    }
  } // apply( Task& ) const
  void Task::Changes::Times::Operations::Change::load_field( const QStringRef& Tag, QXmlStreamReader& Stream )
  {
    if( Tag == "start" )
    {
      Field = Start;
      NewTime = read_time( Stream );
    }
    else if( Tag == "finish" )
    {
      Field = Finish;
      NewTime = read_time( Stream );
    }
    else
      Operation::load_field( Tag, Stream );
  } // load_field( const QStringRef&, QXmlStreamReader& )
  void Task::Changes::Times::Operations::Change::write_fields( QXmlStreamWriter& Stream ) const
  {
    Operation::write_fields( Stream );
    QString Tag;
    switch( Field )
    {
    case Start: Tag = "start"; break;
    case Finish: Tag = "finish"; break;
    default: break;
    }
    Stream.writeTextElement( Tag, time_string( NewTime ) );
  } // write_fields( QXmlStreamWriter& ) const
  Task::Changes::Times* Task::Changes::Times::load( QXmlStreamReader& Stream, TasksFile& /*Tasks*/ )
  {
    Times* Result = new Times;
    Result->load_fields( Stream );
    return Result;
  } // load( QXmlStreamReader&, TasksFile& )
  Task::Changes::Times::Times( Task::Changes::Times::Operation* FirstOperation ) : Change( Change::Times )
  {
    if( FirstOperation )
      Actions.push_back( FirstOperation );
  } // Times( Operation* )
  Task::Changes::Times::~Times()
  {
    while( !Actions.isEmpty() )
    {
      delete Actions.back();
      Actions.pop_back();
    }
  } // ~Times()
  void Task::Changes::Times::apply( Task& Object, TasksFile& /*File*/ ) const
  {
    foreach( Operation* Op, Actions )
      Op->apply( Object );
  } // apply( Task&, TasksFile& ) const
  Task::Changes::Times::Operation* Task::Changes::Times::load_operation( Operation::Type OpCode, QXmlStreamReader& Stream )
  {
    Operation* Result = 0;
    switch( OpCode )
    {
    case Operation::Insert: Result = new Operations::Insert(); break;
    case Operation::Remove: Result = new Operations::Remove(); break;
    case Operation::Move: Result = new Operations::Move(); break;
    case Operation::Change: Result = new Operations::Change(); break;
    default: qDebug() << "!!! Load Times operation: Unknown operation code:" << OpCode; break;
    }
    if( Result ) Result->load_fields( Stream );
    return Result;
  } // load_operation( Operation::Type , QXmlStreamReader& , TasksFile& )
  void Task::Changes::Times::load_fields( QXmlStreamReader& Stream )
  {
    while( Timeshop::Persistent::Loader::next_subelement( Stream ) )
      if( Stream.name() == "operations" )
      {
	while( Timeshop::Persistent::Loader::next_subelement( Stream ) )
	  if( Stream.name() == "operation" )
	  {
	    int OpCode = Operation::None;
	    if( Timeshop::Persistent::Loader::attribute( Stream.attributes(), "type", OpCode ) )
	      if( Operation* Op = load_operation( Operation::Type( OpCode ), Stream ) )
		Actions.push_back( Op );
	      else qDebug() << "??? Can't load operation.";
	    else qDebug() << "!!! Operation without opcode.";
	  }
	  else Timeshop::Persistent::Loader::skip( Stream );
      }	    
      else Timeshop::Persistent::Loader::skip( Stream );
  } // load_fields( QXmlStreamReader& )
  void Task::Changes::Times::write_fields( QXmlStreamWriter& Stream ) const
  {
    Stream.writeStartElement( "operations" );
    foreach( Operation* Op, Actions )
      Op->write( Stream );
    Stream.writeEndElement();
  } // write_fields( QXmlStreamWriter& ) const

  // TasksListChange
  void Task::Changes::TasksListChange::Operation::write( QXmlStreamWriter& Stream ) const
  {
    Stream.writeStartElement( "operation" );
    Stream.writeAttribute( "type", QString::number( type() ) );
    write_fields( Stream );
    Stream.writeEndElement();
  } // write( QXmlStreamWriter& ) const
  void Task::Changes::TasksListChange::Operation::write_fields( QXmlStreamWriter& Stream ) const
  {
    Stream.writeStartElement( "tasks" );
    foreach( Task* T, Tasks )
      Stream.writeTextElement( "task_id", T->id() );
    Stream.writeEndElement();
  } // write_fields( QXmlStreamWriter& ) const
  Task::Changes::TasksListChange::~TasksListChange()
  {
    while( !Actions.empty() )
    {
      delete Actions.back();
      Actions.pop_back();
    }
  } // ~TasksListChange()
  void Task::Changes::TasksListChange::apply( Task& Target, TasksFile& /*File*/ ) const
  {
    foreach( Operation* Op, Actions )
      Op->apply( Target );
  } // apply( Task& ) const
  void Task::Changes::TasksListChange::inform( Task::Watcher& Target, Task& Object ) const
  {
    foreach( Operation* Op, Actions )
      Op->inform( Target, Object );
  } // inform( Task::Watcher&, Task& ) const
  void Task::Changes::TasksListChange::load_fields( QXmlStreamReader& Stream, TasksFile& Tasks )
  {
    while( Timeshop::Persistent::Loader::next_subelement( Stream ) )
      if( Stream.name() == "operations" )
      {
	while( Timeshop::Persistent::Loader::next_subelement( Stream ) )
	  if( Stream.name() == "operation" )
	  {
	    int OpCode = Operation::None;
	    if( Timeshop::Persistent::Loader::attribute( Stream.attributes(), "type", OpCode ) )
	      if( Operation* Op = load_operation( Operation::Type( OpCode ), Stream, Tasks ) )
		Actions.push_back( Op );
	      else qDebug() << "??? Can't load operation.";
	    else qDebug() << "!!! Operation without opcode.";
	  }
	  else Timeshop::Persistent::Loader::skip( Stream );
      }	    
      else Timeshop::Persistent::Loader::skip( Stream );
  } // load_fields( QXmlStreamReader&, TasksFile& )
  Task::Changes::TasksListChange::Operation* Task::Changes::TasksListChange::load_operation( Operation::Type OpCode, QXmlStreamReader& Stream, TasksFile& Tasks )
  {
    qDebug() << "Unknown operation code:" << OpCode << "Don't know how to load it.";
    Timeshop::Persistent::Loader::skip( Stream );
    return 0;
  } // load_operation( Operation::Type, QXmlStreamReader&, TasksFile& )
  void Task::Changes::TasksListChange::write_fields( QXmlStreamWriter& Stream ) const
  {
    Stream.writeStartElement( "operations" );
    foreach( Operation* Op, Actions )
      Op->write( Stream );
    Stream.writeEndElement();
  } // write_fields( QXmlStreamWriter& ) const

  void Task::Changes::TasksListChange::Operation::load_field( const QStringRef& Tag, QXmlStreamReader& Stream, TasksFile& File )
  {
    if( Tag == "tasks" )
      while( Timeshop::Persistent::Loader::next_subelement( Stream ) )
	if( Stream.name() == "task_id" )
	  if( Task::ID TaskID = Stream.readElementText() )
	    if( Task* Object = File.find_task( TaskID ) )
	      Tasks.push_back( Object );
	    else qDebug() << "!!! Task with ID" << TaskID.str() << "not found.";
	  else qDebug() << "!!! Invalid ID in tasks list.";
	else Timeshop::Persistent::Loader::skip( Stream );
    else Timeshop::Persistent::Loader::skip( Stream );
  } // load_field( const QStringRef&, QXmlStreamReader&, TasksFile& )
  void Task::Changes::TasksListChange::Operation::load_fields( QXmlStreamReader& Stream, TasksFile& File )
  {
    while( Timeshop::Persistent::Loader::next_subelement( Stream ) )
      load_field( Stream.name(), Stream, File );
  } // load_fields( QXmlStreamReader&, TasksFile& )
  Task::Changes::TasksListChange::Operations::Move::Move( Task& ToMove0, int From0, int To0 ) : Operation( ToMove0, Operation::Move ), From( From0 ), To( To0 ) {}
  void Task::Changes::TasksListChange::Operations::Move::load_field( const QStringRef& Tag, QXmlStreamReader& Stream, TasksFile& Tasks )
  {
    if( Tag == "from" ) From = Stream.readElementText().toInt();
    else if( Tag == "to" ) To = Stream.readElementText().toInt();
    else Task::Changes::TasksListChange::Operation::load_field( Tag, Stream, Tasks );
  } // load_field( const QStringRef&, QXmlStreamReader&, TasksFile& )
  void Task::Changes::TasksListChange::Operations::Move::write_fields( QXmlStreamWriter& Stream ) const
  {
    Operation::write_fields( Stream );
    Stream.writeTextElement( "from", QString::number( From ) );
    Stream.writeTextElement( "to", QString::number( To ) );
  } // write_fields( QXmlStreamWriter& ) const

  Task::Changes::Blockers::Operations::Add::Add( Task& ToAdd0 ) : Operation( ToAdd0, Operation::Add ) {}
  void Task::Changes::Blockers::Operations::Add::apply( Task& Target ) const
  {
    foreach( Task* Block, Tasks )
      Target.add_blocker( *Block );
  } // apply( Task& ) const
  void Task::Changes::Blockers::Operations::Add::inform( Task::Watcher& Target, Task& Object ) const
  {
    foreach( Task* Block, Tasks )
      Target.blocker_added( Object, *Block );
  } // inform( ( Task::Watcher& Target, const Task& ) const

  Task::Changes::Blockers::Operations::Remove::Remove( Task& ToRemove0 ) : Operation( ToRemove0, Operation::Remove ) {}
  void Task::Changes::Blockers::Operations::Remove::apply( Task& Target ) const
  {
    foreach( Task* Block, Tasks )
      Target.remove_blocker( *Block );
  } // apply( Task& ) const
  void Task::Changes::Blockers::Operations::Remove::inform( Task::Watcher& Target, Task& Object ) const
  {
    foreach( Task* Block, Tasks )
      Target.blocker_removed( Object, *Block );
  } // inform( ( Task::Watcher& Target, const Task& ) const
  Task::Changes::Blockers::Operations::Replace::Replace( const Task::List& ToReplace0 ) : Operation( ToReplace0, Operation::Replace ) {}
  void Task::Changes::Blockers::Operations::Replace::apply( Task& Target ) const
  { //! \todo Make real diff and just apply it.
    if( Tasks.size() > 0 )
    {
      int OldI = 0;
      int NewI = 0;
      while( OldI < Target.blockers().size() && NewI < Tasks.size() )
	if( Target.blocker( OldI ) == Tasks[ NewI ] )
	{
	  OldI++;
	  NewI++;
	}
	else
	  Target.remove_blocker( *Target.blocker( OldI ) );
      while( OldI < Target.blockers().size() )
	Target.remove_blocker( *Target.blocker( OldI ) );
      while( NewI < Tasks.size() )
      {
	Target.add_blocker( *Tasks[ NewI ] );
	NewI++;
      }
    }
    else
      while( Target.blockers().size() > 0 )
	Target.remove_blocker( *Target.blocker( 0 ) );
  } // apply( Task& ) const
  void Task::Changes::Blockers::Operations::Replace::inform( Task::Watcher& Target, Task& Object ) const
  {
    Target.blockers_replaced( Object );
  } // inform( ( Task::Watcher& Target, const Task& ) const
  Task::Changes::Blockers::Operations::Move::Move( Task& ToMove0, int From0, int To0 ) : TasksListChange::Operations::Move( ToMove0, From0, To0 ) {}
  void Task::Changes::Blockers::Operations::Move::apply( Task& Target ) const
  { //! \todo Check if it's right object and correct if needed. Also make it possible to move more than one blocker.
    Target.move_blocker( From, To );
  } // apply( Task& ) const
  void Task::Changes::Blockers::Operations::Move::inform( Task::Watcher& Target, Task& Object ) const
  {
    Target.blocker_moved( Object, *Tasks.front(), From, To );
  } // inform( ( Task::Watcher& Target, const Task& ) const
  Task::Changes::Blockers* Task::Changes::Blockers::load( QXmlStreamReader& Stream, TasksFile& Tasks )
  {
    Blockers* Result = new Blockers;
    Result->load_fields( Stream, Tasks );
    return Result;
  } // load( QXmlStreamReader&, TasksFile& )
  Task::Changes::TasksListChange::Operation* Task::Changes::Blockers::load_operation( Task::Changes::TasksListChange::Operation::Type OpCode, QXmlStreamReader& Stream,
										      TasksFile& Tasks )
  {
    Operation* Result = 0;
    switch( OpCode )
    {
    case Operation::Remove: Result = new Operations::Remove; break;
    case Operation::Replace: Result = new Operations::Replace; break;
    case Operation::Move: Result = new Operations::Move; break;
    default: break; // Nothing
    }
    if( Result ) Result->load_fields( Stream, Tasks );
    else Result = TasksListChange::load_operation( OpCode, Stream, Tasks );
    return Result;
  } // load_operation( Operation::Type, QXmlStreamReader&, TasksFile& )

  Task::Changes::SubTasks::Move::Move( Task& ToMove0, int From0, int To0 ) : TasksListChange::Operations::Move( ToMove0, From0, To0 ) {}
  void Task::Changes::SubTasks::Move::apply( Task& Target ) const
  { //! \todo Check if it's right object and correct if needed.
    Target.move_subtask( From, To );
  } // apply( Task& ) const
  void Task::Changes::SubTasks::Move::inform( Task::Watcher& Target, Task& /*Object*/ ) const
  {
    Target.task_moved( *Tasks.front(), From, To );
  } // inform( ( Task::Watcher& Target, Task& ) const
  Task::Changes::SubTasks* Task::Changes::SubTasks::load( QXmlStreamReader& Stream, TasksFile& Tasks )
  {
    SubTasks* Result = new SubTasks;
    Result->load_fields( Stream, Tasks );
    return Result;
  } // load( QXmlStreamReader&, TasksFile& )
  Task::Changes::TasksListChange::Operation* Task::Changes::SubTasks::load_operation( Task::Changes::TasksListChange::Operation::Type OpCode, QXmlStreamReader& Stream,
										      TasksFile& Tasks )
  {
    Operation* Result = 0;
    if( OpCode == Operation::Move )
    {
      Result = new Move;
      Result->load_fields( Stream, Tasks );
    }
    else Result = TasksListChange::load_operation( OpCode, Stream, Tasks );
    return Result;
  } // load_operation( Operation::Type, QXmlStreamReader&, TasksFile& )
} // PlansPlant
