// -*- coding: utf-8; -*-
// (c) Copyright 2010, Nick Slobodsky (Николай Слободской)
// This file is part of PlansPlant.
//
// PlansPlant is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// PlansPlant is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with PlansPlant.  If not, see <http://www.gnu.org/licenses/>.
//
#ifndef PLANS_PLANT_EXPORT_HPP
#define PLANS_PLANT_EXPORT_HPP
#include <plansplant/tasks.hpp>
namespace PlansPlant
{
  class PLANSPLANT_CLASS ExportFilter
  {
  public:
    ExportFilter( QIODevice* Out0 ) : Out( Out0 ) {}
    virtual ~ExportFilter();
    virtual bool export_tasks( const Task::List& Tasks );
  protected:
    QIODevice* Out;
  }; // ExportFilter

  class PLANSPLANT_CLASS HTMLExportFilter : public ExportFilter
  {
  public:
    HTMLExportFilter( const QString& FileName );
    virtual bool export_tasks( const Task::List& Tasks );
  protected:
    void toc( QTextStream& Str, const Task& T );
    void details( QTextStream& Str, const Task& T, const QString& Prefix = QString() );
    void table_row( QTextStream& Str, const Task& T, const QString& Prefix = QString(), bool EvenRow = false );
  }; // HTMLExportFilter
} // PlansPlant
#endif // PLANS_PLANT_EXPORT_HPP
