//
// fujitsuacprotocol.h
//
// Copyright 2016 by John Pietrzak (jpietrzak8@gmail.com)
//
// This file is part of Pierogi.
//
// Pierogi is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// Pierogi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//

#ifndef FUJITSUACPROTOCOL_H
#define FUJITSUACPROTOCOL_H

#include "spaceprotocol.h"

class PIRInfraredLED;

class FujitsuACProtocol: public SpaceProtocol
{
  Q_OBJECT

public:
  FujitsuACProtocol(
    QObject *guiObject,
    unsigned int index);

public slots:
  void startSendingCommand(
    unsigned int threadableID,
    PIRKeyName command);

private:
  void generateCommand(
    PIRInfraredLED &led);

  void generateStatelessCommand(
    PIRKeyName command,
    PIRInfraredLED &led);

  void setupStatefulPrefixBits();
  void setupStatefulPostfixBits();
  void setupStatelessPrefixBits();
  void setupPowerOffBits();
  void setupStepLouverVerticalBits();
  void setupStepLouverHorizontalBits();

  void appendBitsToSeq(
    CommandSequence &seq,
    int eightBitValue);

  void calculateChecksum(
    CommandSequence &checksum);

  void addBinary(
    CommandSequence::iterator &checksumIter,
    CommandSequence::const_iterator &i,
    bool &carry);

  // State info:
  CommandSequence temperature;
  CommandSequence masterControl;
  CommandSequence timerMode;
  CommandSequence fanSpeed;
  CommandSequence swingMode;
  CommandSequence timerOffDuration;
  CommandSequence timerOffFlag;
  CommandSequence timerOnDuration;
  CommandSequence timerOnFlag;

  // Fixed sequences:
  CommandSequence statefulPrefixBits;
  CommandSequence statefulPostfixBits;
  CommandSequence statelessPrefixBits;
  CommandSequence powerOffBits;
  CommandSequence stepLouverVerticalBits;
  CommandSequence stepLouverHorizontalBits;
};

#endif // FUJITSUACPROTOCOL_H
