//
// blaupunktprotocol.h
//
// Copyright 2016 by John Pietrzak (jpietrzak8@gmail.com)
//
// This file is part of Pierogi.
//
// Pierogi is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// Pierogi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//

#ifndef BLAUPUNKTPROTOCOL_H
#define BLAUPUNKTPROTOCOL_H

#include "pirprotocol.h"

class PIRInfraredLED;

class BlaupunktProtocol: public PIRProtocol
{
  Q_OBJECT

public:
  BlaupunktProtocol(
    QObject *guiObject,
    unsigned int index);

public slots:
  void startSendingCommand(
    unsigned int threadableID,
    PIRKeyName command);

protected:
  unsigned int biphaseUnit;

private:
  int pushPrefixBits(
    PIRInfraredLED &led);

  int pushKeyCommandBits(
    const PIRKeyBits &pkb,
    PIRInfraredLED &led);

  int pushDeviceBits(
    PIRInfraredLED &led);

  int pushBit(
    bool bitValue,
    PIRInfraredLED &led);

  unsigned int buffer;

  // Only one of the following can be true, but both can be false:
  bool bufferContainsSpace;
  bool bufferContainsPulse;
};

#endif // BLAUPUNKTPROTOCOL_H
