#include "daikinprotocol.h"

#include "pirrx51hardware.h"

#include "pirexception.h"

// Some global communication stuff:
#include <QMutex>
extern bool commandInFlight;
extern QMutex commandIFMutex;

// A "stateful" air conditioner protocol.
//
// At the moment, I've only got partial information on Daikin.  Plus, I've got
// two different protocol descriptions.  Both might be different views of
// the same protocol, though.
//
// Protocol one:
// A "zero" is encoded with a 525 usec pulse, 525 usec space.
// A "one" is encoded with a 525 usec pulse, 1600 usec space.
// Commands end with a trailing 525 usec pulse.
// The carrier frequency is 33 kHz.
//
// Protocol two:
// A "zero" is encoded with a 425 usec pulse, 440 usec space.
// A "one" is encoded with a 425 usec pulse, 1300 usec space.
// The header is a 3440 usec pulse, 1745 usec space.
// Commands end with a trailing 425 usec pulse.
// There is a 30000 usec space mid-command, and a 100000 usec space at the
// end of a command.
// The carrier frequency is 38 kHz.
