#include "aiwa.h"
#include "protocols/lircprotocol.h"

AiwaDVD1::AiwaDVD1(
  QObject *guiObject,
  unsigned int index)
  : PIRKeysetMetaData(
      "DVD Keyset 1",
      Aiwa_Make,
      index)
{
  LIRCProtocol *lp = new LIRCProtocol(
    guiObject,
    index,
    500, 622,
    1629, 622,
    99349, false);

  threadableProtocol = lp;

  lp->setHeaderPair(1623, 615);
  lp->setRepeatPair(8967, 4467);

  addKey("KEY_POWER", Power_Key, 0x201, 10);
  addKey("KEY_SUBTITLE", Captions_Key, 0x32C, 10);
  addKey("KEY_RED", Red_Key, 0x2F1, 10);
  addKey("KEY_GREEN", Green_Key, 0x390, 10);
  addKey("KEY_YELLOW", Yellow_Key, 0x370, 10);
  addKey("KEY_BLUE", Blue_Key, 0x3AC, 10);
  addKey("KEY_EPG", Guide_Key, 0x360, 10);
  addKey("KEY_INFO", Info_Key, 0x211, 10);
  addKey("KEY_OK", Select_Key, 0x28D, 10);
  addKey("KEY_BACK", Exit_Key, 0x348, 10);
  addKey("KEY_MENU", Menu_Key, 0x30C, 10);
  addKey("KEY_UP", Up_Key, 0x24D, 10);
  addKey("KEY_DOWN", Down_Key, 0x34C, 10);
  addKey("KEY_LEFT", Left_Key, 0x3CC, 10);
  addKey("KEY_RIGHT", Right_Key, 0x2CD, 10);
  addKey("KEY_REWIND", Rewind_Key, 0x2D9, 10);
  addKey("KEY_PLAYPAUSE", Play_Key, 0x350, 10);
  addKey("KEY_PLAYPAUSE", Pause_Key, 0x350, 10);
  addKey("KEY_FORWARD", FastForward_Key, 0x358, 10);
  addKey("KEY_STOP", Stop_Key, 0x2B1, 10);
  addKey("KEY_RECORD", Record_Key, 0x3EC, 10);
  addKey("KEY_CHANNELUP", ChannelUp_Key, 0x231, 10);
  addKey("KEY_CHANNELDOWN", ChannelDown_Key, 0x330, 10);
  addKey("KEY_1", One_Key, 0x300, 10);
  addKey("KEY_2", Two_Key, 0x281, 10);
  addKey("KEY_3", Three_Key, 0x380, 10);
  addKey("KEY_4", Four_Key, 0x241, 10);
  addKey("KEY_5", Five_Key, 0x340, 10);
  addKey("KEY_6", Six_Key, 0x2C1, 10);
  addKey("KEY_7", Seven_Key, 0x3C0, 10);
  addKey("KEY_8", Eight_Key, 0x221, 10);
  addKey("KEY_9", Nine_Key, 0x320, 10);
  addKey("KEY_0", Zero_Key, 0x2A1, 10);
  addKey("KEY_MEDIA", Unmapped_Key, 0x348, 10);
}
