#ifdef USE_HILDON
static void
theme_chosen_cb(const char *theme_type, char *filename)
{
/*
	struct theme_info {
		gchar *type;
		gchar *extension;
		gchar *original_name;
	};
*/
	struct theme_info *ti = g_new0(struct theme_info, 1);
	char *tmp = NULL;

	g_print("theme_chosen_cb: %s\n", filename);

	if (ti) {
		ti->type = g_strdup(theme_type);
		ti->extension = g_strdup(g_strrstr(filename, "."));

		tmp = g_strrstr(filename, G_DIR_SEPARATOR_S);
		ti->original_name = g_strdup(tmp ? tmp : filename);

		theme_install_theme(filename, ti);
	}
}

static void
add_theme_button_clicked(GtkWidget *btn, const char *theme_type)
{
	purple_request_file(prefs, _("Install Theme"), NULL, FALSE,
	                    G_CALLBACK(theme_chosen_cb), NULL,
	                    NULL, NULL, NULL, (gpointer)theme_type);
}

static GtkWidget *
make_add_theme_button(const char *theme_type)
{
	GtkWidget *btn = g_object_new(HILDON_TYPE_BUTTON,
		"visible",     TRUE,
		"title",       _("Add"),
		"size",        HILDON_SIZE_FINGER_HEIGHT,
		"arrangement", HILDON_BUTTON_ARRANGEMENT_VERTICAL,
		NULL);

	g_signal_connect(G_OBJECT(btn), "clicked", (GCallback)add_theme_button_clicked, (gpointer)theme_type);

	return btn;
}
#endif /* USE_HILDON */

