/**
 * @file pidgin.h UI definitions and includes
 * @ingroup pidgin
 */

/* pidgin
 *
 * Pidgin is the legal property of its developers, whose names are too numerous
 * to list here.  Please refer to the COPYRIGHT file distributed with this
 * source distribution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02111-1301  USA
 */
/* #warning ***pidgin*** */
#ifndef _PIDGIN_H_
#define _PIDGIN_H_

#include <gtk/gtk.h>

#ifdef GDK_WINDOWING_X11
# include <gdk/gdkx.h>
#endif

#ifdef _WIN32
# include "gtkwin32dep.h"
#endif

#ifdef USE_HILDON
#include "hildon-headers.h"
#endif /* USE_HILDON */

/**
 * Our UI's identifier.
 */
/* leave this as gtk-gaim until we have a decent way to migrate UI-prefs */
#define PIDGIN_UI "gtk-gaim"

#define USE_DOCKLET
#ifdef USE_HILDON
#	if !HILDON_CHECK_VERSION(1,0,0)
#		undef USE_DOCKLET
#	endif /* HILDON < 1.0.0 */
#endif /* USE_HILDON */

/* change this only when we have a sane upgrade path for old prefs */
#define PIDGIN_PREFS_ROOT "/pidgin"

#ifdef USE_HILDON
#	if HILDON_CHECK_VERSION(2,1,0)
#		define HAVE_HILDON_TEXT_VIEW
#	endif /* HILDON >= 2.1.0 */
#endif /* USE_HILDON */

/* Translators may want to transliterate the name.
 It is not to be translated. */
#define PIDGIN_NAME _("Pidgin")

#ifndef _WIN32
# define PIDGIN_ALERT_TITLE ""
#else
# define PIDGIN_ALERT_TITLE PIDGIN_NAME
#endif

#define USE_CLOSE_AND_CANCEL_BUTTONS
#ifdef USE_HILDON
#	if HILDON_CHECK_VERSION(2,1,0)
#		undef USE_CLOSE_AND_CANCEL_BUTTONS
#	endif /* HILDON >= 2.1.0 */
#endif /* USE_HILDON */

/*
 * This is backwards-compatibility code for older versions of GTK+ (< 2.4.x)
 * It defines the new wrap behavior (unknown in earlier versions)
 * as the old (slightly buggy) wrap behavior.
 * It also includes our back-ported GtkExpander
 */
/** @cond */
#if (!GTK_CHECK_VERSION(2,4,0))
# define GTK_WRAP_WORD_CHAR GTK_WRAP_WORD
# include "gtkexpander.h"
#endif
/** @endcond */

/*
 * We include the sources for GtkComboBox and GtkCellView because
 * they don't exist in older versions of GTK+, and we use them
 * in a few places.
 */
#if !GTK_CHECK_VERSION(2,6,0)
#   include "gtkcellview.h"
#   include "gtkcellviewmenuitem.h"
#   include "pidgincombobox.h"
#   if !GTK_CHECK_VERSION(2,4,0)
#       include "gtkcelllayout.h"
#   endif /* Less than GTK+ 2.4 */
#endif /* Less than GTK+ 2.6 */

/*
 * Spacings between components, as defined by the
 * GNOME Human Interface Guidelines.
 */
#ifdef USE_HILDON
#define PIDGIN_HIG_CAT_SPACE      6
#define PIDGIN_HIG_BORDER         2
#define PIDGIN_HIG_BOX_SPACE      2
#else /* !USE_HILDON */
#define PIDGIN_HIG_CAT_SPACE     18
#define PIDGIN_HIG_BORDER        12
#define PIDGIN_HIG_BOX_SPACE      6
#endif /* USE_HILDON */

#if !GTK_CHECK_VERSION(2,16,0) || !defined(PIDGIN_DISABLE_DEPRECATED)
/*
 * Older versions of GNOME defaulted to using an asterisk as the invisible
 * character.  But this is ugly and we want to use something nicer.
 *
 * The default invisible character was changed in GNOME revision 21446
 * (GTK+ 2.16) from an asterisk to the first available character out of
 * 0x25cf, 0x2022, 0x2731, 0x273a.  See GNOME bugs 83935 and 307304 for
 * discussion leading up to the change.
 *
 * Here's the change:
 * http://svn.gnome.org/viewvc/gtk%2B?view=revision&revision=21446
 *
 */
#define PIDGIN_INVISIBLE_CHAR (gunichar)0x25cf
#endif /* Less than GTK+ 2.16 */

#ifdef USE_HILDON
#if HILDON_CHECK_VERSION(2,1,0)

/* Re-define checkboxes to be HildonCheckButton widgets */
#ifndef LEAVE_TOGGLE_BUTTONS_ALONE
#define gtk_check_button_new_with_mnemonic(thelabel) \
	(g_object_new(HILDON_TYPE_CHECK_BUTTON,            \
		"size",          HILDON_SIZE_FINGER_HEIGHT,      \
		"label",         (thelabel),                     \
		"use-underline", TRUE,                           \
		"xalign",        0.0,                            \
		NULL))
#define gtk_toggle_button_get_active(thebutton) \
	(hildon_check_button_get_active((thebutton)))
#define gtk_toggle_button_set_active(thebutton,active) \
	(hildon_check_button_set_active((thebutton),(active)))
#define GTK_TOGGLE_BUTTON(thebutton) (HILDON_CHECK_BUTTON((thebutton)))
#endif /* !LEAVE_TOGGLE_BUTTONS_ALONE */

/* Re-define GtkEntry widgets to be HildonEntry widgets */
#define gtk_entry_new() \
	hildon_entry_new(HILDON_SIZE_FINGER_HEIGHT)

/* Re-define GtkButton widgets to be HildonButton widgets */
#define gtk_button_new() \
	g_object_new(HILDON_TYPE_BUTTON,     \
		"size", HILDON_SIZE_FINGER_HEIGHT, \
		NULL)
#define gtk_button_new_with_label(thelabel) \
	g_object_new(HILDON_TYPE_BUTTON,          \
	"size", HILDON_SIZE_FINGER_HEIGHT,        \
	"label", (thelabel),                      \
	NULL)
#define gtk_button_new_from_stock(thestockid) \
	g_object_new(HILDON_TYPE_BUTTON,            \
	"size", HILDON_SIZE_FINGER_HEIGHT,          \
	"label", (thestockid),                      \
	"use-stock", TRUE,                          \
	NULL)
#define gtk_button_new_with_mnemonic(thelabel) \
	g_object_new(HILDON_TYPE_BUTTON,             \
	"size", HILDON_SIZE_FINGER_HEIGHT,           \
	"label", (thelabel),                         \
	"use-underline", TRUE,                       \
	NULL)

#endif /* HILDON >= 2.1.0 */
#endif /* USE_HILDON */

#endif /* _PIDGIN_H_ */

