#ifndef DATA_DATE_H
#define DATA_DATE_H

#include "../Data.h"

#include <Lum/Base/DateTime.h>

namespace Data {

  class Date : public ::Base::Data
  {
  public:
    class DateType : public ::Base::Type
    {
    public:
      enum RepeatMode
      {
        noRepeat       = 1,
        dailyRepeat    = 2,
        weeklyRepeat   = 3,
        monthlyRepeat  = 4,
        yearlyRepeat   = 5
      };

    public:
      enum Attribute
      {
        description    = 0,
        startDate      = 1,
        endDate        = 2,
        repeat         = 3,
        repeatEndDate  = 4,
        repeatInterval = 5,
        wholeDay       = 6,
        startTime      = 7,
        endTime        = 8
      };

    public:
      DateType();

      unsigned long GetMaxAttribute() const;
      bool IsPrimaryType() const;

      ::Base::DataPtr Create() const;
    };

  public:
    static DateType *dateType;

  public:
    std::wstring         description;
    Lum::Base::Calendar  startDate;
    Lum::Base::Calendar  endDate;
    DateType::RepeatMode repeat;
    Lum::Base::Calendar  repeatEndDate;
    unsigned long        repeatInterval;
    bool                 wholeDay;
    Lum::Base::Time      startTime;
    Lum::Base::Time      endTime;

  public:
    Date();

    std::wstring GetDisplayText() const;

    void SetAttribute(::Base::Id id, const std::wstring& value);
    std::wstring GetAttribute(::Base::Id id) const;

    std::wstring GetDateTimeString() const;

    bool operator>(const Date& date) const;
  };

  typedef Date *DatePtr;
}

#endif
