#ifndef VIEWS_NOTES_H
#define VIEWS_NOTES_H

#include <list>

#include <Lum/Model/Table.h>

#include <Lum/Panel.h>
#include <Lum/Table.h>

#include "../GUI.h"

#include "../Data/Note.h"

namespace Views {

  class NotesEntry
  {
  public:
    ::Data::NotePtr note;

  public:
    NotesEntry(::Data::NotePtr note)
    : note(note)
    {
      // no code
    }
  };

  typedef Lum::Model::StdTable<NotesEntry*>     NotesEntryModel;
  typedef Lum::Base::Reference<NotesEntryModel> NotesEntryModelRef;

  class Notes : public ::Base::View
  {
  private:
    Lum::Model::ActionRef    viewAction;
    Lum::Model::ActionRef    addAction;
    Lum::Model::ActionRef    deleteAction;
    NotesEntryModelRef       model;
    Lum::Table               *table;
    Lum::Panel               *top;

  private:
    void FillList();

  public:
    Notes();
    ~Notes();

    bool VisitChildren(Lum::Visitor &visitor, bool onlyVisible);

    void CalcSize();
    void Layout();

    void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);

    void Load(DataPtr data);
    void Vanish();
  };
}

#endif
