#ifndef DATA_PERSON_H
#define DATA_PERSON_H

#include "../Data.h"

namespace Data {
  class Person : public ::Base::Data
  {
  public:
    class PersonType : public ::Base::Type
    {
    public:
      enum Attribute
      {
        title      = 0,
        surename   = 1,
        middlename = 2,
        name       = 3,
        suffix     = 4,
        nick       = 5
      };

    public:
      PersonType();

      unsigned long GetMaxAttribute() const;
      bool IsPrimaryType() const;

      ::Base::DataPtr Create() const;
    };

  public:
    static PersonType *personType;

  public:
    std::wstring title;
    std::wstring surename;
    std::wstring middlename;
    std::wstring name;
    std::wstring suffix;
    std::wstring nick;

  public:
    Person();

    bool IsGreater(Data* other) const;

    std::wstring GetDisplayText() const;

    void SetAttribute(::Base::Id id, const std::wstring& value);
    std::wstring GetAttribute(::Base::Id id) const;
  };

  typedef Person *PersonPtr;
}

#endif
