#ifndef VIEWS_SEARCH_H
#define VIEWS_SEARCH_H

#include "../GUI.h"

#include <list>

#include <Lum/Model/String.h>
#include <Lum/Model/Table.h>

#include <Lum/Panel.h>
#include <Lum/Table.h>

namespace Views {

  class Search : public ::Base::View
  {
  private:
    Lum::Model::ActionRef    viewAction;
    Lum::Model::ActionRef    searchAction;
    Lum::Model::ListTableRef model;
    Lum::Model::StringRef    searchValue;
    Lum::Table               *table;
    Lum::Panel               *top;

  private:
    void FillList();

  public:
    Search();
    ~Search();

    bool VisitChildren(Lum::Visitor &visitor, bool onlyVisible);

    void CalcSize();
    void Layout();

    void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);

    void Load(DataPtr data);
    void Vanish();
  };

}

#endif
