#include "View.h"

#include <Lum/Dlg/Msg.h>

#include <Lum/Button.h>
#include <Lum/ButtonRow.h>
#include <Lum/Menu.h>
#include <Lum/Panel.h>

#include "Database.h"
#include "GUI.h"
#include "BaseDialogs.h"
#include <iostream>
#include <Lum/Base/Util.h>
namespace Base {
  View::Data::Data(::Base::DataPtr data)
  : data(data),linkData(NULL),linkName(L"")
  {
    // no code
  }

  View::Data::Data(::Base::DataPtr data,
                   ::Base::DataPtr linkData,
                   const std::wstring linkName)
  : data(data),linkData(linkData),linkName(linkName)
  {
    // no code
  }

  View::Data::~Data()
  {
    // no code
  }

  bool View::Data::RequestsLink() const
  {
    return linkData!=NULL;
  }

  void View::Data::ClearLinkInfo()
  {
    linkData=NULL;
    linkName.clear();
  }

  View::View(const std::wstring& name)
  : name(name)
  {
    // no code
  }

  std::wstring View::GetName() const
  {
    return name;
  }

  class LinkEntry : public Lum::Model::ListTable::Entry
  {
  public:
    LinkPtr link;
    DataPtr data;

  public:
    LinkEntry(Lum::Model::ListTable* table,
              LinkPtr link, DataPtr data)
    : Lum::Model::ListTable::Entry(table),link(link),data(data)
    {
      // no code
    }

    std::wstring GetString(size_t column) const
    {
      switch (column) {
      case 1:
        return link->GetName();
      case 2:
        return data->GetType()->GetName();
      case 3:
        return data->GetDisplayText();
      default:
        return L"";
      }
    }

    bool IsGreater(const Entry* other, size_t column) const
    {
      const LinkEntry *tmp=dynamic_cast<const LinkEntry*>(other);

      switch (column) {
      case 1:
        if (link->GetName()!=tmp->link->GetName()) {
          return link->GetName()>tmp->link->GetName();
        }
        else if (data->GetType()->GetName()!=tmp->data->GetType()->GetName()) {
          return data->GetType()->GetName()>tmp->data->GetType()->GetName();
        }
        else {
          return data->IsGreater(tmp->data);
        }
      case 2:
       if (data->GetType()->GetName()!=tmp->data->GetType()->GetName()) {
          return data->GetType()->GetName()>tmp->data->GetType()->GetName();
        }
        else if (link->GetName()!=tmp->link->GetName()) {
          return link->GetName()>tmp->link->GetName();
        }
        else {
          return data->IsGreater(tmp->data);
        }
      case 3:
        return data->IsGreater(tmp->data);
      default:
        assert(false);
      }
    }
  };

  DataView::DataView(const std::wstring& name)
  : View(name),linkTable(NULL),linkModel(new Lum::Model::ListTable()),
    panel(NULL),data(NULL)
  {
    showLinkAction=new Lum::Model::Action();
    addLinkAction=new Lum::Model::Action();
    referenceAction=new Lum::Model::Action();
    renameLinkAction=new Lum::Model::Action();
    deleteLinkAction=new Lum::Model::Action();

    Observe(showLinkAction);
    Observe(addLinkAction);
    Observe(referenceAction);
    Observe(renameLinkAction);
    Observe(deleteLinkAction);

    saveAction=new Lum::Model::Action;
    Observe(saveAction);
  }

  DataView::~DataView()
  {
    delete panel;
  }

  void DataView::RefreshLinkTable()
  {
    LinkEntry                 *entry;
    ::Base::LinkConstIterator iter;

    const ::Base::LinkList &refList=data->GetLinks();

    linkModel->Off();
    linkModel->Clear();
    iter=refList.begin();
    while (iter!=refList.end()) {
      if (data==(*iter)->GetFirst()) {
        entry=new LinkEntry(linkModel,(*iter),(*iter)->GetSecond());
      }
      else {
        entry=new LinkEntry(linkModel,(*iter),(*iter)->GetFirst());
      }

      linkModel->Append(entry);

      ++iter;
    }

    linkModel->Sort(2);
    linkModel->On();
  }

  void DataView::Load(DataPtr viewData)
  {
    RefreshLinkTable();
  }

  void DataView::Vanish()
  {
    linkModel->Clear();

    viewData=NULL;
    data=NULL;
  }

  void DataView::SetViewData(DataPtr viewData)
  {
    assert(viewData!=NULL);

    this->viewData=viewData;
    data=viewData->data;
  }

  void DataView::RegisterDataViews(Lum::Tab*& tab)
  {
    Lum::Menu             *menu;
    Lum::Panel            *panel;
    Lum::Model::HeaderRef headerModel;

    panel=Lum::VPanel::Create(true,true);

    headerModel=new Lum::Model::HeaderImpl();
    headerModel->AddColumn(L"Reference",Lum::Base::Size::stdCharWidth,8);
    headerModel->AddColumn(L"Type",Lum::Base::Size::stdCharWidth,8);
    headerModel->AddColumn(L"Description",Lum::Base::Size::stdCharWidth,50);

    linkTable=new Lum::Table();
    linkTable->SetFlex(true,true);
    linkTable->SetShowHeader(true);
    linkTable->SetModel(linkModel);
    linkTable->SetHeaderModel(headerModel);
    linkTable->SetSelection(new Lum::Model::SingleLineSelection());
    linkTable->SetDoubleClickAction(showLinkAction);
    panel->Add(linkTable);

    menu=new Lum::Menu();
    menu->SetParent(GetWindow());
    menu->AddActionItem(L"View",showLinkAction);
    menu->AddActionItem(L"Add",addLinkAction);
    menu->AddActionItem(L"Reference",referenceAction);
    menu->AddActionItem(L"Rename",renameLinkAction);
    menu->AddActionItem(L"Delete",deleteLinkAction);
    linkTable->SetMenu(menu->GetWindow());

    tab->Add(L"Links",panel);
  }

  bool DataView::VisitChildren(Lum::Visitor &visitor, bool onlyVisible)
  {
    if (panel!=NULL) {
      return visitor.Visit(panel);
    }

    return true;
  }

  void DataView::CalcSize()
  {
    Lum::Tab       *tab;

    panel=Lum::VPanel::Create(true,true);
    panel->SetParent(this);

    tab=Lum::Tab::Create(true,true);

    panel->Add(tab);
    panel->AddSpace();
    panel->Add(Lum::ButtonRow::Create(true,false)
               ->Add(Lum::Button::Create(L"_Save",saveAction,true,true)));

    RegisterDataViews(tab);

    panel->CalcSize();

    width=panel->GetOWidth();
    height=panel->GetOHeight();
    minWidth=panel->GetOMinWidth();
    minHeight=panel->GetOMinHeight();
    maxWidth=panel->GetOMaxWidth();
    maxHeight=panel->GetOMaxHeight();

    View::CalcSize();
  }

  void DataView::Layout()
  {
    panel->Resize(width,height);
    panel->Move(x,y);

    View::Layout();
  }

  void DataView::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
  {
    if (model==showLinkAction && showLinkAction->IsFinished()) {
      if (linkTable->GetTableView()->GetSelection()->HasSelection()) {
        size_t line;
        Data *data;

        line=dynamic_cast<Lum::Model::SingleLineSelection*>(linkTable->GetTableView()->GetSelection())->GetLine();
        data=new Data(dynamic_cast< LinkEntry*>(linkModel->GetEntry(line))->data);
        GUI::GetInstance()->ShowView(data->data->GetType()->GetName(),data);
      }
    }
    else if (model==addLinkAction && addLinkAction->IsFinished()) {
      std::wstring linkName,typeName;

      if (GetLinkNameType(GetWindow(),linkName,typeName)) {
        TypePtr type;

        type=Type::GetTypeByName(typeName);
        if (type!=NULL) {
          ::Base::DataPtr data;
          Data            *viewData;

          data=type->Create();
          viewData=new Data(data,this->data,linkName);
          GUI::GetInstance()->ShowView(typeName,viewData);
        }
      }
    }
    else if (model==referenceAction && referenceAction->IsFinished()) {
      std::wstring    linkName;
      ::Base::DataPtr data;

      if (GetDataLink(GetWindow(),linkName,data)) {
        this->data->LinkData(linkName,data);
        RefreshLinkTable();
      }
    }
    else if (model==renameLinkAction && renameLinkAction->IsFinished()) {
      size_t       line;
      LinkPtr      link;
      std::wstring name;

      line=dynamic_cast<Lum::Model::SingleLineSelection*>(linkTable->GetTableView()->GetSelection())->GetLine();
      link=dynamic_cast< LinkEntry*>(linkModel->GetEntry(line))->link;

      name=link->GetName();
      if (GetStringValue(GetWindow(),
                         L"Renaming link '"+name+L"'",
                         30,
                         //L"Please enter the new name for link '"+name+L"':",
                         name)) {
        link->SetName(name);
        // TODO: Refresh cell!
      }

    }
    else if (model==deleteLinkAction && deleteLinkAction->IsFinished()) {
      if (linkTable->GetTableView()->GetSelection()->HasSelection()) {
        size_t          line;
        LinkPtr         link;
        ::Base::DataPtr data;
        bool            removeObject=false;

        line=dynamic_cast<Lum::Model::SingleLineSelection*>(linkTable->GetTableView()->GetSelection())->GetLine();
        link=dynamic_cast< LinkEntry*>(linkModel->GetEntry(line))->link;
        data=dynamic_cast< LinkEntry*>(linkModel->GetEntry(line))->data;

        if (data->GetLinkCount()==1 && Lum::Dlg::Msg::Ask(GetWindow(),
                                                          L"Should the referenced object\nbe deleted, too?",
                                                          std::wstring(L"The current link is the last reference to the object\n'")+
                                                          data->GetDisplayText()+L"' of type '"+data->GetType()->GetName()+L"'\n"+
                                                          L"and thus will possibly not be reachable after deleting\nthis link.\n",
                                                          L"_Delete it, too!*|Do_n't delete it^")==0) {
          removeObject=true;
        }

        this->data->Remove(link);
        data->Remove(link);
        if (removeObject) {
          database->Remove(data);
        }
        RefreshLinkTable(); // TODO
      }
    }
    else {
      View::Resync(model,msg);
    }
  }

  void DataView::RegisterModel(Lum::Base::Model* model)
  {
    models.push_back(model);
    Observe(model);
  }

  bool DataView::IsRegisteredModel(Lum::Base::Model* model) const
  {
    std::list<Lum::Base::Model*>::const_iterator iter;

    iter=models.begin();
    while (iter!=models.end()) {
      if (*iter==model) {
        return true;
      }

      ++iter;
    }

    return false;
  }
}
