#  MAD_INCLUDE_DIRS - where to find mad.h, etc.
#  MAD_LIBRARIES    - List of libraries when using libmad.
#  MAD_FOUND        - True if libmad found.

# Look for the header file.
FIND_PATH(MAD_INCLUDE_DIR NAMES mad.h)
MARK_AS_ADVANCED(MAD_INCLUDE_DIR)

# Look for the library.
FIND_LIBRARY(MAD_LIBRARY NAMES mad)
MARK_AS_ADVANCED(MAD_LIBRARY)

# Copy the results to the output variables.
IF(MAD_INCLUDE_DIR AND MAD_LIBRARY)
  SET(MAD_FOUND 1)
  SET(MAD_LIBRARIES ${MAD_LIBRARY})
  SET(MAD_INCLUDE_DIRS ${MAD_INCLUDE_DIR})
ELSE(MAD_INCLUDE_DIR AND MAD_LIBRARY)
  SET(MAD_FOUND 0)
  SET(MAD_LIBRARIES)
  SET(MAD_INCLUDE_DIRS)
ENDIF(MAD_INCLUDE_DIR AND MAD_LIBRARY)

# Report the results.
IF(NOT MAD_FOUND)
  SET(MAD_DIR_MESSAGE
    "libmad was not found. Make sure MAD_LIBRARY and MAD_INCLUDE_DIR are set.")
  IF(NOT MAD_FIND_QUIETLY)
    MESSAGE(STATUS "${MAD_DIR_MESSAGE}")
  ELSE(NOT MAD_FIND_QUIETLY)
    IF(MAD_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "${MAD_DIR_MESSAGE}")
    ENDIF(MAD_FIND_REQUIRED)
  ENDIF(NOT MAD_FIND_QUIETLY)
ENDIF(NOT MAD_FOUND)
