#ifndef VIEW_H
#define VIEW_H
//-----------------------------------------------------------------------------

#include <QMainWindow>

//-----------------------------------------------------------------------------
class Context;
class OCRLanguageSettings;

//-----------------------------------------------------------------------------
class View:
  public QMainWindow
{
  Q_OBJECT

  public:
    View(Context* a_context, QWidget* a_parent);
    ~View();

  public slots:
    void showSettings();
    void toggleBusy(bool a_busy);
    void showError(const QString& a_error);
    void showOCRLanguageSettings();

  protected:
    Context* m_context;
    OCRLanguageSettings *m_ocrSettings;

    QAction* m_actSettings;
};

//-----------------------------------------------------------------------------
#endif // VIEW_H
