#ifndef TRANSLATOR_GOOGLE_H
#define TRANSLATOR_GOOGLE_H
//-----------------------------------------------------------------------------

#include "Translator.h"

#include <QMap>

//-----------------------------------------------------------------------------
class QNetworkAccessManager;
class QNetworkReply;

//-----------------------------------------------------------------------------
class Translator_Google:
  public Translator
{
  Q_OBJECT

  public:
    Translator_Google(QObject* a_parent);
    ~Translator_Google();

  public:
    virtual QList<int> supportedLanguages() const;

  public slots:
    virtual void run(const QString& a_text, int a_langFrom, int a_langTo);
    virtual bool cancel();

  protected slots:
    void replyFinished();

  protected:
    void parseReply();
    void parseError();

  private:
    QNetworkAccessManager* m_network;
    QNetworkReply* m_reply;

    QMap<int, QString> m_mapLanguage;

    bool m_cancelled;
};

//-----------------------------------------------------------------------------
#endif // TRANSLATOR_GOOGLE_H
