//-----------------------------------------------------------------------------
#include "View_Start.h"
#include "ui_View_Start.h"
//-----------------------------------------------------------------------------

#include "Context.h"
#include "View_Image.h"
#include "View_Translate.h"
#include "settings/Settings.h"
#include "CameraWidget.h"

#include <QFileDialog>
#include <QProcess>
#include <gst/gst.h>

#include <QDebug>

//-----------------------------------------------------------------------------
View_Start::View_Start(Context* a_context, QWidget* a_parent):
  View(a_context, a_parent),
  m_ui(new Ui::View_Start)
{
  qDebug() << "View_Start::View_Start()";

  m_ui->setupUi(this);
}

//-----------------------------------------------------------------------------
View_Start::~View_Start()
{
  qDebug() << "View_Start::~View_Start()";

  delete m_ui;
}

//-----------------------------------------------------------------------------
void View_Start::initialize()
{
}

//-----------------------------------------------------------------------------
void View_Start::on_translate_clicked()
{
  // Show translate view
  View_Translate* viewTranslate = new View_Translate(m_context, this);
  viewTranslate->initialize(false);
  viewTranslate->show();
}

//-----------------------------------------------------------------------------
void View_Start::on_open_clicked()
{
  qDebug() << "View_Start::on_open_clicked()";

  QString strPath = QDir::homePath();

  QString strPathPrevious = m_context->settings()->openDir();
  QDir dirPathPrevious(strPathPrevious);
  if(!strPathPrevious.isEmpty() && dirPathPrevious.exists())
    strPath = dirPathPrevious.absolutePath();
  else
  {
    qDebug() << "View_Start::on_open_clicked(): failed directory =" << dirPathPrevious;

    QString strPathDCIM("/media/mmc1/DCIM");
    QDir dirDCIM(strPathDCIM);
    if(dirDCIM.exists())
      strPath = dirDCIM.absolutePath();
    else
    {
      qDebug() << "View_Start::on_open_clicked(): failed directory =" << strPathDCIM;

      QString strPathImages = QDir::homePath() + QString("/MyDocs/.images");
      QDir dirImages(strPathImages);
      if(dirImages.exists())
        strPath = dirImages.absolutePath();
      else
      {
        qDebug() << "View_Start::on_open_clicked(): failed directory =" << strPathImages;

        QString strPathData = m_context->programInstallDir() + QString("/data/");
        QDir dirData(strPathData);
        if(dirData.exists())
          strPath = dirData.absolutePath();
        else
          qDebug() << "View_Start::on_open_clicked(): failed directory =" << strPathData;
      }
    }
  }
  qDebug() << "View_Start::on_open_clicked(): open directory =" << strPath;

  QString strFile = QFileDialog::getOpenFileName( this, tr("Open picture"), strPath,
                                                  tr("Images (*.png *.jpg *.tif)") );
  if(strFile.isNull())
  {
    qDebug() << "View_Start::on_open_clicked(): Cancelled";
    return;
  }

  qDebug() << "View_Start::on_open_clicked(): open file =" << strFile;

  // Save path to settings
  QDir dirOpened(strFile.left(strFile.lastIndexOf(QRegExp("[\\\\/]"))));
  m_context->settings()->setOpenDir(dirOpened.absolutePath());
  m_context->settings()->save();

  // Show image view
  View_Image* viewImage = new View_Image(m_context, this);
  viewImage->show();
  viewImage->initialize(strFile);
}

//-----------------------------------------------------------------------------
void View_Start::on_camera_clicked()
{/*
      QProcess m_process;
      qDebug() << "View_Start::on_camera_clicked() before start";
      m_process.start("gst-launch-0.10 v4l2src !videoscale !video/x-raw-yuv,width=320,height=240 ! xvimagesink");
      qDebug() << "View_Start::on_camera_clicked() after start";
      */
	CameraWidget *camera = new CameraWidget(m_context, this);
}

//-----------------------------------------------------------------------------
