#ifndef UTILS_H
#define UTILS_H
//-----------------------------------------------------------------------------

#include <QPolygonF>
#include <QLineF>

//-----------------------------------------------------------------------------
class Utils
{
  public:
    static QPolygonF makeBoundRect(const QPointF& a_p1, const QPointF& a_p2);
    static QLineF makeLineShortenedFromEnds(const QPointF& a_p1, const QPointF& a_p2, qreal a_short);

    static QRect toAbsoluteFromRelative(const QSize& a_size, const QRectF& a_relative);
    static QPointF toRelativeFromAbsolute(const QSize& a_size, const QPoint& a_absolute);
};

//-----------------------------------------------------------------------------
#endif // UTILS_H
