#include "CameraWidget.h"
#include "ui_CameraWidget.h"

#include "Context.h"
#include "Definitions.h"
#include "View.h"
#include "View_Image.h"

#include <QDebug>
#include <QWidget>
#include <QMessageBox>
#include <QProcess>

#include <gst/gst.h>
#include <gst/interfaces/xoverlay.h>
#include "glib.h"

#include <QTimer>

CameraWidget::CameraWidget(Context* a_context, QWidget* a_parent):
  View(a_context, a_parent),
  m_ui(new Ui::CameraWidget)
{
  qDebug() << "CameraWidget::CameraWidget()";

  m_ui->setupUi(this);
  QTimer::singleShot( 100, this, SLOT( initialize() ) );

}

CameraWidget::~CameraWidget()
{
	m_ui->widget->hide();
	gst_element_set_state (pipeline, GST_STATE_NULL);
	gst_object_unref (pipeline);

}

void CameraWidget::initialize()
{

    WId xwinid = m_ui->widget->winId();

    src = gst_element_factory_make ("v4l2src", NULL);//, videotestsrc

    vscale = gst_element_factory_make ("videoscale", NULL);//, videotestsrc

    sink= gst_element_factory_make ("xvimagesink", NULL);

    pipeline = gst_pipeline_new ("xvoverlay");

    gst_bin_add_many (GST_BIN (pipeline), src, vscale, sink, NULL);

    gst_element_link_many (src,vscale, sink, NULL);

    QApplication::syncX();

    gst_x_overlay_set_xwindow_id (GST_X_OVERLAY (sink), (gulong)(xwinid));

    gst_element_set_state (pipeline, GST_STATE_NULL);
    gst_element_set_state (pipeline, GST_STATE_PLAYING);

}

void CameraWidget::on_ButtonPicture_clicked()
{
  //  m_process.startDetached(" gst-launch v4l2camsrc device=/dev/video0 num-buffers=1 ! dspjpegenc ! filesink location=/usr/share/doc/poza.jpg");
	gst_element_set_state (pipeline, GST_STATE_NULL);

	QProcess process;

    process.startDetached(" gst-launch v4l2src device=/dev/video0 num-buffers=1 ! dspjpegenc ! filesink location=/usr/share/doc/poza.jpg");

    sleep(3);
	QString strFile = "/usr/share/doc/poza.jpg";

	// Show image view
	View_Image* viewImage = new View_Image(m_context, this);

	viewImage->show();
	viewImage->initialize(strFile);

	process.close();

    process.startDetached("rm /usr/share/doc/poza.jpg");
}

bool CameraWidget::event( QEvent * myEvent )
{
   qDebug() << "ShowEvent!!!!!!" << myEvent->type();

   if( myEvent->type() == /*QEvent::WindowActivate*/ QEvent::ChildRemoved)
   {
        gst_object_unref (pipeline);

        QTimer::singleShot( 100, this, SLOT( initialize() ) );

   }

   return View::event( myEvent );
}


