//-----------------------------------------------------------------------------
#include "BusyWidget.h"
//-----------------------------------------------------------------------------

#include <QPainter>
#include <QPaintEvent>

#include <QDebug>

//-----------------------------------------------------------------------------
BusyWidget::BusyWidget(QWidget* a_parent):
  QWidget(a_parent)
{
  m_timer.setInterval(150);
  m_timer.setSingleShot(false);
  connect(&m_timer, SIGNAL(timeout()), this, SLOT(onTimeout()));

  m_blocks = 8;
  m_current = 0;
  m_maxBoxSize = 70;
}

//-----------------------------------------------------------------------------
BusyWidget::~BusyWidget()
{
}

//-----------------------------------------------------------------------------
void BusyWidget::onTimeout()
{
  m_current++;
  if(m_current >= m_blocks)
    m_current = 0;

  update();
}

//-----------------------------------------------------------------------------
void BusyWidget::hideEvent(QHideEvent* a_event)
{
  QWidget::hideEvent(a_event);

  m_timer.stop();
}

//-----------------------------------------------------------------------------
void BusyWidget::showEvent(QShowEvent* a_event)
{
  QWidget::showEvent(a_event);

  m_current = 0;
  m_timer.start();
}

//-----------------------------------------------------------------------------
void BusyWidget::paintEvent(QPaintEvent* a_event)
{
  QPainter painter(this);

  QRect rectClip = a_event->rect();
  painter.setClipRect(rectClip);

  painter.setRenderHint(QPainter::Antialiasing);

  qreal busySize = qreal( width() < height() ? width() : height() );
  if(busySize > m_maxBoxSize)
    busySize = m_maxBoxSize;
  qreal rectWidth = busySize * 0.30;
  qreal rectHeight = rectWidth * 0.30;
  QRectF rectBox(QPointF(busySize * 0.20, -rectHeight / 2), QSizeF(rectWidth, rectHeight));
  qreal angleShift = 360.0 / qreal(m_blocks);

  painter.setPen(Qt::NoPen);
  painter.translate(width()/2, height()/2);
  for(int i = 0; i < m_blocks; i++)
  {
    if(i == m_current)
      painter.setBrush(QBrush(QColor(0xFF, 0xFF, 0xFF, 0xFF)));
    else
      painter.setBrush(QBrush(QColor(0xFF, 0xFF, 0xFF, 0x40)));

    painter.rotate(angleShift);
    painter.drawRect(rectBox);
  }
}

//-----------------------------------------------------------------------------
