#ifndef VIEW_TRANSLATE_H
#define VIEW_TRANSLATE_H
//-----------------------------------------------------------------------------

#include "View.h"

//-----------------------------------------------------------------------------
class QPushButton;

//-----------------------------------------------------------------------------
namespace Ui
{
  class View_Translate;
}

//-----------------------------------------------------------------------------
class View_Translate:
  public View
{
  Q_OBJECT

  public:
    View_Translate(Context* a_context, QWidget* a_parent = NULL);
    ~View_Translate();

  public:
    void initialize(bool a_fromImage);

  public slots:
    void onOcr();
    void onTranslate();
    void onCancel();

    void doneOcr(QString a_text);
    void errorOcr(QString a_error);
    void doneTranslator(QString a_text);
    void errorTranslator(QString a_error);

    void onSourceLang();
    void onTargetLang();
    void onSettingsChanged(quint32 a_changed);
    void onSourceTextChanged();

  protected slots:
    void refreshLanguageButtons();

  private:
    Ui::View_Translate* m_ui;

    bool m_fromImage;
    bool m_processing;

    QPushButton* m_buttonSourceLang;
    QPushButton* m_buttonTargetLang;
};

//-----------------------------------------------------------------------------
#endif // VIEW_TRANSLATE_H
